/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.utils;

import java.util.Arrays;
import lombok.Generated;

public abstract class SimpleResetPool<T, C> {
    protected final C context;
    protected Object[] pool;
    protected int cursor;
    protected int size;

    public SimpleResetPool(int size, C context) {
        this.size = size;
        this.pool = new Object[size];
        this.context = context;
        this.cursor = 0;
        for (int i = 0; i < this.size; ++i) {
            this.pool[i] = this.create(this.context, i);
        }
    }

    protected abstract T create(C var1, int var2);

    protected abstract void reset(T var1);

    protected abstract void delete(T var1);

    public T get(boolean force) {
        Object t;
        if (this.cursor < this.size && this.test(t = this.pool[this.cursor++])) {
            this.init(t);
            return (T)t;
        }
        return this.fail(force);
    }

    public void reset() {
        for (int i = 0; i < this.cursor; ++i) {
            this.reset(this.pool[i]);
        }
        this.cursor = 0;
    }

    public void delete() {
        for (int i = 0; i < this.size; ++i) {
            this.delete(this.pool[i]);
        }
    }

    protected void expand() {
        int old = this.size;
        this.size = old * 2;
        this.pool = Arrays.copyOf(this.pool, this.size);
        for (int i = old; i < this.size; ++i) {
            this.pool[i] = this.create(this.context, i);
        }
    }

    public T at(int index) {
        return (T)this.pool[index];
    }

    public T get() {
        return this.get(false);
    }

    public void init(T t) {
    }

    protected T fail(boolean force) {
        return this.fail();
    }

    public T fail() {
        return null;
    }

    protected boolean test(T t) {
        return true;
    }

    @Generated
    public C getContext() {
        return this.context;
    }

    @Generated
    public Object[] getPool() {
        return this.pool;
    }

    @Generated
    public int getCursor() {
        return this.cursor;
    }
}

