/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.culling;

import com.github.argon4w.acceleratedrendering.core.backends.programs.ComputeProgram;
import com.github.argon4w.acceleratedrendering.core.backends.programs.Uniform;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.AcceleratedBufferBuilder;
import com.github.argon4w.acceleratedrendering.core.programs.ComputeShaderProgramLoader;
import com.github.argon4w.acceleratedrendering.core.programs.culling.ICullingProgramDispatcher;
import com.github.argon4w.acceleratedrendering.features.culling.OrientationCullingFeature;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.resources.ResourceLocation;

public class OrientationCullingProgramDispatcher
implements ICullingProgramDispatcher {
    private static final int GROUP_SIZE = 128;
    private static final int DISPATCH_COUNT_Y_Z = 1;
    private final VertexFormat.Mode mode;
    private final ComputeProgram program;
    private final Uniform viewMatrixUniform;
    private final Uniform projectMatrixUniform;
    private final Uniform polygonCountUniform;
    private final Uniform vertexOffsetUniform;
    private final Uniform varyingOffsetUniform;

    public OrientationCullingProgramDispatcher(VertexFormat.Mode mode, ResourceLocation key) {
        this.mode = mode;
        this.program = ComputeShaderProgramLoader.getProgram(key);
        this.viewMatrixUniform = this.program.getUniform("viewMatrix");
        this.projectMatrixUniform = this.program.getUniform("projectMatrix");
        this.polygonCountUniform = this.program.getUniform("polygonCount");
        this.vertexOffsetUniform = this.program.getUniform("vertexOffset");
        this.varyingOffsetUniform = this.program.getUniform("varyingOffset");
    }

    @Override
    public int dispatch(AcceleratedBufferBuilder builder) {
        int vertexCount = builder.getTotalVertexCount();
        int polygonCount = vertexCount / this.mode.primitiveLength;
        this.viewMatrixUniform.uploadMatrix4f(RenderSystem.getModelViewMatrix());
        this.projectMatrixUniform.uploadMatrix4f(RenderSystem.getProjectionMatrix());
        this.polygonCountUniform.uploadUnsignedInt(polygonCount);
        this.vertexOffsetUniform.uploadUnsignedInt((int)(builder.getVertexBuffer().getOffset() / builder.getVertexSize()));
        this.varyingOffsetUniform.uploadUnsignedInt((int)(builder.getVaryingBuffer().getOffset() / builder.getVaryingSize()));
        this.program.useProgram();
        this.program.dispatch((polygonCount + 128 - 1) / 128, 1, 1);
        return this.program.getBarrierFlags();
    }

    @Override
    public boolean shouldCull() {
        return OrientationCullingFeature.shouldCull();
    }
}

