/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.items.mixins;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.utils.DirectionUtils;
import com.github.argon4w.acceleratedrendering.features.items.AcceleratedItemRenderingFeature;
import com.github.argon4w.acceleratedrendering.features.items.AcceleratedQuadsRenderer;
import com.github.argon4w.acceleratedrendering.features.items.BakedModelExtension;
import com.github.argon4w.acceleratedrendering.features.items.IAcceleratedBakedModel;
import com.github.argon4w.acceleratedrendering.features.items.colors.ItemLayerColors;
import com.github.argon4w.acceleratedrendering.features.items.contexts.AcceleratedQuadsRenderContext;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ItemRenderer.class})
public class ItemRendererMixin {
    @WrapOperation(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/ItemRenderer;renderModelLists(Lnet/minecraft/client/resources/model/BakedModel;Lnet/minecraft/world/item/ItemStack;IILcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;)V")})
    public void renderFast(ItemRenderer instance, BakedModel pModel, ItemStack pStack, int pCombinedLight, int pCombinedOverlay, PoseStack pPoseStack, VertexConsumer pBuffer, Operation<Void> original) {
        IAcceleratedVertexConsumer extension1 = VertexConsumerExtension.getAccelerated(pBuffer);
        IAcceleratedBakedModel extension2 = BakedModelExtension.getAccelerated(pModel);
        if (!(AcceleratedItemRenderingFeature.isEnabled() && AcceleratedItemRenderingFeature.shouldUseAcceleratedPipeline() && (CoreFeature.isRenderingLevel() || CoreFeature.isRenderingHand() && (extension2.isAcceleratedInHand() || AcceleratedItemRenderingFeature.shouldAccelerateInHand()) || CoreFeature.isRenderingGui() && (extension2.isAcceleratedInGui() || AcceleratedItemRenderingFeature.shouldAccelerateInGui())) && extension1.isAccelerated())) {
            original.call(new Object[]{instance, pModel, pStack, pCombinedLight, pCombinedOverlay, pPoseStack, pBuffer});
            return;
        }
        if (extension2.isAccelerated()) {
            extension2.renderItemFast(pStack, RandomSource.create((long)42L), pPoseStack.last(), extension1, pCombinedLight, pCombinedOverlay);
            return;
        }
        if (!AcceleratedItemRenderingFeature.shouldBakeMeshForQuad()) {
            original.call(new Object[]{instance, pModel, pStack, pCombinedLight, pCombinedOverlay, pPoseStack, pBuffer});
            return;
        }
        PoseStack.Pose pose = pPoseStack.last();
        RandomSource randomSource = RandomSource.create();
        for (Direction direction : DirectionUtils.FULL) {
            randomSource.setSeed(42L);
            extension1.doRender(AcceleratedQuadsRenderer.INSTANCE, new AcceleratedQuadsRenderContext(pModel.getQuads(null, direction, randomSource), new ItemLayerColors(pStack)), pose.pose(), pose.normal(), pCombinedLight, pCombinedOverlay, -1);
        }
    }
}

