/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.modelparts.mixins;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IBufferGraph;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import com.github.argon4w.acceleratedrendering.core.meshes.IMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.CulledMeshCollector;
import com.github.argon4w.acceleratedrendering.core.meshes.data.IMeshData;
import com.github.argon4w.acceleratedrendering.features.entities.AcceleratedEntityRenderingFeature;
import com.github.argon4w.acceleratedrendering.features.modelparts.IAcceleratedModelPart;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelPart.class})
public class ModelPartMixin
implements IAcceleratedRenderer<Void>,
IAcceleratedModelPart {
    @Shadow
    @Final
    private List<ModelPart.Cube> cubes;
    @Unique
    private final Map<IBufferGraph, IMesh> meshes = new Object2ObjectOpenHashMap();
    @Unique
    private final Map<IMeshData, IMesh> merges = new Object2ObjectOpenHashMap();

    @Inject(method={"compile"}, at={@At(value="HEAD")}, cancellable=true)
    public void compileFast(PoseStack.Pose pPose, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, int pColor, CallbackInfo ci) {
        IAcceleratedVertexConsumer extension = VertexConsumerExtension.getAccelerated(pBuffer);
        if (AcceleratedEntityRenderingFeature.isEnabled() && AcceleratedEntityRenderingFeature.shouldUseAcceleratedPipeline() && (CoreFeature.isRenderingLevel() || CoreFeature.isRenderingGui() && AcceleratedEntityRenderingFeature.shouldAccelerateInGui()) && extension.isAccelerated()) {
            ci.cancel();
            extension.doRender(this, null, pPose.pose(), pPose.normal(), pPackedLight, pPackedOverlay, pColor);
        }
    }

    @Override
    @Unique
    public void render(VertexConsumer vertexConsumer, Void context, Matrix4f transform, Matrix3f normal, int light, int overlay, int color) {
        IAcceleratedVertexConsumer extension = VertexConsumerExtension.getAccelerated(vertexConsumer);
        IMesh mesh = this.meshes.get(extension);
        extension.beginTransform(transform, normal);
        if (mesh != null) {
            mesh.write(extension, color, light, overlay);
            extension.endTransform();
            return;
        }
        CulledMeshCollector culledMeshCollector = new CulledMeshCollector(extension);
        VertexConsumer meshBuilder = extension.decorate(culledMeshCollector);
        for (ModelPart.Cube cube : this.cubes) {
            for (ModelPart.Polygon polygon : cube.polygons) {
                Vector3f polygonNormal = polygon.normal;
                for (ModelPart.Vertex vertex : polygon.vertices) {
                    Vector3f vertexPosition = vertex.pos;
                    meshBuilder.addVertex(vertexPosition.x / 16.0f, vertexPosition.y / 16.0f, vertexPosition.z / 16.0f, -1, vertex.u, vertex.v, overlay, 0, polygonNormal.x, polygonNormal.y, polygonNormal.z);
                }
            }
        }
        culledMeshCollector.flush();
        IMeshData data = culledMeshCollector.getData();
        ByteBufferBuilder buffer = culledMeshCollector.getBuffer();
        mesh = this.merges.get(data);
        if (mesh != null) {
            buffer.discard();
            buffer.close();
        } else {
            mesh = AcceleratedEntityRenderingFeature.getMeshType().getBuilder().build(culledMeshCollector);
        }
        this.meshes.put(extension, mesh);
        this.merges.put(data, mesh);
        mesh.write(extension, color, light, overlay);
        extension.endTransform();
    }

    @Override
    @Unique
    public void clearMeshCacheUnsafe() {
        this.merges.clear();
        this.meshes.clear();
    }
}

