/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.compat.iris.mixins.acceleratedrendering;

import com.github.argon4w.acceleratedrendering.compat.iris.interfaces.IIrisAcceleratedBufferBuilder;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.AcceleratedRingBuffers;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.AcceleratedBufferBuilder;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.layers.functions.ILayerFunction;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.ElementBufferPool;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.StagingBufferPool;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.irisshaders.iris.vertices.IrisVertexFormats;
import net.minecraft.client.renderer.RenderType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AcceleratedBufferBuilder.class})
public class AcceleratedBufferBuilderMixin
implements IIrisAcceleratedBufferBuilder {
    @Shadow(remap=false)
    @Final
    private IMemoryLayout<VertexFormatElement> layout;
    @Shadow(remap=false)
    private long vertexAddress;
    @Unique
    private IMemoryInterface entityIdOffset;
    @Unique
    private IMemoryInterface entityOffset;

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    public void constructor(StagingBufferPool.StagingBuffer vertexBuffer, StagingBufferPool.StagingBuffer varyingBuffer, ElementBufferPool.ElementSegment elementSegment, AcceleratedRingBuffers.Buffers buffers, ILayerFunction layerFunction, RenderType renderType, CallbackInfo ci) {
        this.entityIdOffset = this.layout.getElement(IrisVertexFormats.ENTITY_ID_ELEMENT);
        this.entityOffset = this.layout.getElement(IrisVertexFormats.ENTITY_ELEMENT);
    }

    @Inject(method={"vertex(FFFFFFFFFIIFFF)V"}, at={@At(value="TAIL")}, remap=false)
    public void addIrisVertex(float pX, float pY, float pZ, float red, float green, float blue, float alpha, float pU, float pV, int pPackedOverlay, int pPackedLight, float pNormalX, float pNormalY, float pNormalZ, CallbackInfo ci, @Local(name={"vertexAddress"}) long vertexAddress) {
        this.addIrisData(vertexAddress);
    }

    @Inject(method={"vertex(DDD)Lcom/mojang/blaze3d/vertex/VertexConsumer;"}, at={@At(value="TAIL")}, remap=false)
    public void addIrisVertex(double pX, double pY, double pZ, CallbackInfoReturnable<VertexConsumer> cir) {
        this.addIrisData(this.vertexAddress);
    }

    @Inject(method={"addServerMesh", "addClientMesh"}, at={@At(value="INVOKE", target="Lcom/github/argon4w/acceleratedrendering/core/buffers/memory/IMemoryInterface;putInt(JI)V", ordinal=2, shift=At.Shift.AFTER)}, remap=false)
    public void addIrisMesh(CallbackInfo ci, @Local(name={"vertexAddress"}) long vertexAddress) {
        this.addIrisData(vertexAddress);
    }

    @Unique
    private void addIrisData(long vertexAddress) {
        this.entityOffset.putShort(vertexAddress + 0L, (short)-1);
        this.entityOffset.putShort(vertexAddress + 2L, (short)-1);
        this.entityIdOffset.putShort(vertexAddress + 0L, (short)CapturedRenderingState.INSTANCE.getCurrentRenderedEntity());
        this.entityIdOffset.putShort(vertexAddress + 2L, (short)CapturedRenderingState.INSTANCE.getCurrentRenderedBlockEntity());
        this.entityIdOffset.putShort(vertexAddress + 4L, (short)CapturedRenderingState.INSTANCE.getCurrentRenderedItem());
    }

    @Override
    @Unique
    public IMemoryInterface getEntityIdOffset() {
        return this.entityIdOffset;
    }

    @Override
    @Unique
    public IMemoryInterface getEntityOffset() {
        return this.entityOffset;
    }
}

