/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.blocks.cache;

import com.github.argon4w.acceleratedrendering.core.buffers.blocks.cache.IBlockBufferBindingCache;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

public class FlattenBlockBufferBindingCache
implements IBlockBufferBindingCache {
    public static final VarHandle HANDLE = MethodHandles.arrayElementVarHandle(long[].class).withInvokeExactBehavior();
    public static final int BLOCK_BUFFER_BINDING_SIZE = 3;
    public static final int BUFFER_OFFSET = 0;
    public static final int OFFSET_OFFSET = 1;
    public static final int SIZE_OFFSET = 2;
    private final long[] cache;

    public FlattenBlockBufferBindingCache(int size) {
        this.cache = new long[size * 3];
    }

    @Override
    public void delete() {
    }

    @Override
    public void setup(int bindingPoint, int buffer, long offset, long size) {
        int bindingIndex = bindingPoint * 3;
        HANDLE.set(this.cache, bindingIndex + 0, buffer);
        HANDLE.set(this.cache, bindingIndex + 1, offset);
        HANDLE.set(this.cache, bindingIndex + 2, size);
    }

    @Override
    public int getBuffer(int bindingPoint) {
        return (int)HANDLE.get(this.cache, bindingPoint * 3 + 0);
    }

    @Override
    public long getOffset(int bindingPoint) {
        return HANDLE.get(this.cache, bindingPoint * 3 + 1);
    }

    @Override
    public long getSize(int bindingPoint) {
        return HANDLE.get(this.cache, bindingPoint * 3 + 2);
    }
}

