/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.entities;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class AcceleratedEntityShadowRenderer
implements IAcceleratedRenderer<Context> {
    @Override
    public void render(VertexConsumer vertexConsumer, Context context, Matrix4f transform, Matrix3f normal, int light, int overlay, int color) {
        IAcceleratedVertexConsumer extension = VertexConsumerExtension.getAccelerated(vertexConsumer);
        LevelReader levelReader = context.levelReader();
        ChunkAccess chunkAccess = context.chunkAccess();
        BlockPos blockPos = context.blockPos();
        Vector3f center = context.center();
        float size = context.size();
        float weight = context.weight();
        BlockPos belowPos = context.blockPos().below();
        BlockState blockState = chunkAccess.getBlockState(belowPos);
        if (blockState.getRenderShape() == RenderShape.INVISIBLE) {
            return;
        }
        int levelBrightness = levelReader.getMaxLocalRawBrightness(blockPos);
        if (levelBrightness <= 3) {
            return;
        }
        if (!blockState.isCollisionShapeFullBlock((BlockGetter)chunkAccess, belowPos)) {
            return;
        }
        VoxelShape voxelShape = blockState.getShape((BlockGetter)chunkAccess, belowPos);
        if (voxelShape.isEmpty()) {
            return;
        }
        float dimensionBrightness = LightTexture.getBrightness((DimensionType)levelReader.dimensionType(), (int)levelBrightness);
        float shadowTransparency = weight * 0.5f * dimensionBrightness * 255.0f;
        if (shadowTransparency < 0.0f) {
            return;
        }
        if (shadowTransparency > 255.0f) {
            shadowTransparency = 255.0f;
        }
        int shadowColor = FastColor.ARGB32.color((int)((int)shadowTransparency), (int)color);
        AABB bounds = voxelShape.bounds();
        float minX = (float)blockPos.getX() + (float)bounds.minX;
        float maxX = (float)blockPos.getX() + (float)bounds.maxX;
        float minY = (float)blockPos.getY() + (float)bounds.minY;
        float minZ = (float)blockPos.getZ() + (float)bounds.minZ;
        float maxZ = (float)blockPos.getZ() + (float)bounds.maxZ;
        float minPosX = minX - center.x;
        float maxPosX = maxX - center.x;
        float minPosY = minY - center.y;
        float minPosZ = minZ - center.z;
        float maxPosZ = maxZ - center.z;
        float u0 = -minPosX / 2.0f / size + 0.5f;
        float u1 = -maxPosX / 2.0f / size + 0.5f;
        float v0 = -minPosZ / 2.0f / size + 0.5f;
        float v1 = -maxPosZ / 2.0f / size + 0.5f;
        extension.beginTransform(transform, normal);
        Vector3f[] positions = new Vector3f[]{new Vector3f(minPosX, minPosY, minPosZ), new Vector3f(minPosX, minPosY, maxPosZ), new Vector3f(maxPosX, minPosY, maxPosZ), new Vector3f(maxPosX, minPosY, minPosZ)};
        Vector2f[] texCoords = new Vector2f[]{new Vector2f(u0, v0), new Vector2f(u0, v1), new Vector2f(u1, v1), new Vector2f(u1, v0)};
        for (int i = 0; i < 4; ++i) {
            Vector3f position = positions[i];
            Vector2f texCoord = texCoords[i];
            vertexConsumer.addVertex(position.x, position.y, position.z, shadowColor, texCoord.x, texCoord.y, overlay, light, 0.0f, 1.0f, 0.0f);
        }
        extension.endTransform();
    }

    public record Context(LevelReader levelReader, ChunkAccess chunkAccess, BlockPos blockPos, Vector3f center, float size, float weight) {
    }
}

