/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.compat.curios;

import com.github.argon4w.acceleratedrendering.configs.FeatureConfig;
import com.github.argon4w.acceleratedrendering.configs.FeatureStatus;
import com.github.argon4w.acceleratedrendering.core.utils.RegistryFilter;
import com.github.argon4w.acceleratedrendering.features.filter.FilterType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CuriosCompatFeature {
    public static final Deque<FeatureStatus> LAYER_ACCELERATION_CONTROLLER_STACK = new ArrayDeque<FeatureStatus>();
    public static final Deque<FeatureStatus> CURIOS_ITEM_FILTER_CONTROLLER_STACK = new ArrayDeque<FeatureStatus>();
    private static final Set<Item> CURIOS_ITEM_FILTER_VALUES = RegistryFilter.filterValues(BuiltInRegistries.f_257033_, (List)FeatureConfig.CONFIG.curiosItemFilterValues.get());

    public static boolean isEnabled() {
        return FeatureConfig.CONFIG.curiosCompatFeatureStatus.get() == FeatureStatus.ENABLED;
    }

    public static boolean testCuriosItem(ItemStack itemStack) {
        return CuriosCompatFeature.getCuriosItemFilterType().test(CURIOS_ITEM_FILTER_VALUES, itemStack.m_41720_());
    }

    public static boolean shouldAccelerateCurios() {
        return CuriosCompatFeature.getLayerAccelerationSetting() == FeatureStatus.ENABLED;
    }

    public static boolean shouldFilterCuriosItems() {
        return CuriosCompatFeature.getCuriosItemFilterSetting() == FeatureStatus.ENABLED;
    }

    public static FilterType getCuriosItemFilterType() {
        return (FilterType)((Object)FeatureConfig.CONFIG.curiosItemFilterType.get());
    }

    public static void disableLayerAcceleration() {
        LAYER_ACCELERATION_CONTROLLER_STACK.push(FeatureStatus.DISABLED);
    }

    public static void disableCuriosItemFilter() {
        CURIOS_ITEM_FILTER_CONTROLLER_STACK.push(FeatureStatus.DISABLED);
    }

    public static void forceEnableLayerAcceleration() {
        LAYER_ACCELERATION_CONTROLLER_STACK.push(FeatureStatus.ENABLED);
    }

    public static void forceEnableCuriosItemFilter() {
        CURIOS_ITEM_FILTER_CONTROLLER_STACK.push(FeatureStatus.ENABLED);
    }

    public static void forceSetLayerAcceleration(FeatureStatus status) {
        LAYER_ACCELERATION_CONTROLLER_STACK.push(status);
    }

    public static void forceSetCuriosItemFilter(FeatureStatus status) {
        CURIOS_ITEM_FILTER_CONTROLLER_STACK.push(status);
    }

    public static void resetLayerAcceleration() {
        LAYER_ACCELERATION_CONTROLLER_STACK.pop();
    }

    public static void resetCuriosItemFilter() {
        CURIOS_ITEM_FILTER_CONTROLLER_STACK.pop();
    }

    public static FeatureStatus getLayerAccelerationSetting() {
        return LAYER_ACCELERATION_CONTROLLER_STACK.isEmpty() ? CuriosCompatFeature.getDefaultLayerAccelerationSettings() : LAYER_ACCELERATION_CONTROLLER_STACK.peek();
    }

    public static FeatureStatus getCuriosItemFilterSetting() {
        return CURIOS_ITEM_FILTER_CONTROLLER_STACK.isEmpty() ? CuriosCompatFeature.getDefaultCuriosItemFilterSetting() : CURIOS_ITEM_FILTER_CONTROLLER_STACK.peek();
    }

    public static FeatureStatus getDefaultLayerAccelerationSettings() {
        return (FeatureStatus)((Object)FeatureConfig.CONFIG.curiosCompatLayerAcceleration.get());
    }

    public static FeatureStatus getDefaultCuriosItemFilterSetting() {
        return (FeatureStatus)((Object)FeatureConfig.CONFIG.curiosItemFilter.get());
    }
}

