/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.compat.iris.mixins.plugin;

import com.github.argon4w.acceleratedrendering.compat.AbstractCompatMixinPlugin;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;

public class IrisCompatMixinPlugin
extends AbstractCompatMixinPlugin {
    public static final ILogger LOGGER = MixinService.getService().getLogger("Accelerated Rendering");
    public static final String MIXIN_CLASS = "com.github.argon4w.acceleratedrendering.compat.iris.mixins.vanilla.BufferBuilderMixin";
    public static final String TARGET_CLASS = "com.mojang.blaze3d.vertex.BufferBuilder";
    public static final String TARGET_METHOD = "fillExtendedData";
    public static final int TARGET_OPCODE = 16;
    public static final int TARGET_OPERAND_TANGENT = 6;
    public static final int TARGET_OPERAND_MID_U = 14;
    public static final int TARGET_OPERAND_MID_V = 10;
    public static final int FIXED_OPERAND_TANGENT = 4;
    public static final int FIXED_OPERAND_MID_U = 12;
    public static final int FIXED_OPERAND_MID_V = 8;

    @Override
    protected List<String> getModIDs() {
        return List.of("iris", "oculus");
    }

    @Override
    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        if (mixinClassName.equals(MIXIN_CLASS) || targetClassName.equals(TARGET_CLASS)) {
            LOGGER.info("Found target class: ", new Object[0]);
            LOGGER.info("- Target class name: \"{}\".", new Object[]{targetClassName});
            LOGGER.info("- Mixin class name: \"{}\".", new Object[]{mixinClassName});
            Int2ObjectOpenHashMap fixNode = new Int2ObjectOpenHashMap();
            fixNode.put(6, (Object)ObjectIntPair.of((Object)"at_tangent", (int)4));
            fixNode.put(14, (Object)ObjectIntPair.of((Object)"midU", (int)12));
            fixNode.put(10, (Object)ObjectIntPair.of((Object)"midV", (int)8));
            for (MethodNode method : targetClass.methods) {
                if (!method.name.equals(TARGET_METHOD)) continue;
                LOGGER.info("Found target method: ", new Object[0]);
                LOGGER.info("- Target method name: \"{}\".", new Object[]{method.name});
                LOGGER.info("- Target method desc: \"{}\".", new Object[]{method.desc});
                for (AbstractInsnNode instruction : method.instructions) {
                    if (!(instruction instanceof IntInsnNode)) continue;
                    IntInsnNode intNode = (IntInsnNode)instruction;
                    int targetOperand = intNode.operand;
                    int targetOpcode = intNode.getOpcode();
                    ObjectIntPair fixedOperand = (ObjectIntPair)fixNode.get(targetOperand);
                    if (targetOpcode != 16 || fixedOperand == null) continue;
                    LOGGER.info("Found instruction of mismatched \"{}\" attribute offset: ", new Object[]{fixedOperand.left()});
                    LOGGER.info("- Instruction operand: \"{}\".", new Object[]{targetOperand});
                    LOGGER.info("- Instruction opcode: \"{}\".", new Object[]{targetOpcode});
                    intNode.operand = fixedOperand.rightInt();
                    fixNode.remove(targetOperand);
                    LOGGER.info("Successfully modified mismatched \"{}\" attribute offset to \"{}\" from \"{}\".", new Object[]{fixedOperand.left(), fixedOperand.rightInt(), targetOperand});
                }
                if (!fixNode.isEmpty()) {
                    LOGGER.warn("Modification failed.", new Object[0]);
                    LOGGER.warn("Cannot found mismatched attribute offset, {} left.", new Object[]{fixNode.size()});
                    LOGGER.warn("Mismatched attribute offset not found: ", new Object[0]);
                    for (Int2ObjectMap.Entry entry : fixNode.int2ObjectEntrySet()) {
                        LOGGER.warn("- \"{}\" with value \"{}\" was supposed to be changed to \"{}\".", new Object[]{entry.getIntKey(), ((ObjectIntPair)entry.getValue()).left(), ((ObjectIntPair)entry.getValue()).rightInt()});
                    }
                }
                return;
            }
            LOGGER.warn("Cannot found target method \"{}\".", new Object[]{TARGET_METHOD});
            LOGGER.warn("Modification failed.", new Object[0]);
        }
    }
}

