/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.backends.buffers;

import com.github.argon4w.acceleratedrendering.core.backends.buffers.IServerBuffer;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL46;

public class ImmutableBuffer
implements IServerBuffer {
    protected final int bufferHandle = GL46.glCreateBuffers();

    public ImmutableBuffer(long size, int bits) {
        GL46.glNamedBufferStorage((int)this.bufferHandle, (long)size, (int)bits);
    }

    public void copyTo(IServerBuffer buffer, long size) {
        GL46.glCopyNamedBufferSubData((int)this.bufferHandle, (int)buffer.getBufferHandle(), (long)0L, (long)0L, (long)size);
    }

    public long map(long length, int bits) {
        return GL46.nglMapNamedBufferRange((int)this.bufferHandle, (long)0L, (long)length, (int)bits);
    }

    public void unmap() {
        GL46.glUnmapNamedBuffer((int)this.bufferHandle);
    }

    @Override
    public int getBufferHandle() {
        return this.bufferHandle;
    }

    @Override
    public void delete() {
        GL46.glDeleteBuffers((int)this.bufferHandle);
    }

    @Override
    public void bind(int target) {
        GL46.glBindBuffer((int)target, (int)this.bufferHandle);
    }

    @Override
    public void data(ByteBuffer data) {
        GL46.glNamedBufferSubData((int)this.bufferHandle, (long)0L, (ByteBuffer)data);
    }

    @Override
    public void bindBase(int target, int index) {
        GL46.glBindBufferBase((int)target, (int)index, (int)this.bufferHandle);
    }

    @Override
    public void bindRange(int target, int index, long offset, long size) {
        GL46.glBindBufferRange((int)target, (int)index, (int)this.bufferHandle, (long)offset, (long)size);
    }
}

