/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.backends.states.buffers.cache;

import com.github.argon4w.acceleratedrendering.core.backends.states.buffers.cache.FlattenBlockBufferBindingCache;
import com.github.argon4w.acceleratedrendering.core.backends.states.buffers.cache.IBlockBufferBindingCache;
import com.github.argon4w.acceleratedrendering.core.backends.states.buffers.cache.SimpleBlockBufferBindingCache;
import com.github.argon4w.acceleratedrendering.core.backends.states.buffers.cache.UnsafeMemoryBlockBufferBindingCache;

public enum BlockBufferBindingCacheType {
    SIMPLE,
    UNSAFE,
    HANDLE;


    public IBlockBufferBindingCache create(int size) {
        return BlockBufferBindingCacheType.create(this, size);
    }

    public static IBlockBufferBindingCache create(BlockBufferBindingCacheType type, int size) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case SIMPLE -> new SimpleBlockBufferBindingCache(size);
            case HANDLE -> new FlattenBlockBufferBindingCache(size);
            case UNSAFE -> new UnsafeMemoryBlockBufferBindingCache(size);
        };
    }
}

