/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.backends.states.scissors;

import com.github.argon4w.acceleratedrendering.core.backends.states.IBindingState;
import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import org.lwjgl.opengl.GL46;

public class MojangScissorBindingState
implements IBindingState {
    private boolean recorded;
    private boolean enabled = false;
    private int scissorX = 0;
    private int scissorY = 0;
    private int scissorWidth = 0;
    private int scissorHeight = 0;

    @Override
    public void record(GuiGraphics graphics) {
        ScreenRectangle rect = (ScreenRectangle)graphics.f_279587_.f_279656_.peekLast();
        if (rect != null) {
            Window window = Minecraft.m_91087_().m_91268_();
            int height = window.m_85442_();
            double scale = window.m_85449_();
            this.scissorY = (int)((double)height - (double)rect.m_274349_() * scale);
            this.scissorX = (int)((double)rect.m_274563_() * scale);
            this.scissorWidth = (int)((double)rect.f_263770_() * scale);
            this.scissorHeight = (int)((double)rect.f_263800_() * scale);
            this.enabled = true;
        } else {
            this.enabled = false;
        }
        this.recorded = true;
    }

    @Override
    public void restore() {
        if (!this.recorded) {
            return;
        }
        if (this.enabled) {
            GL46.glEnable((int)3089);
            GL46.glScissor((int)this.scissorX, (int)this.scissorY, (int)this.scissorWidth, (int)this.scissorHeight);
        } else {
            GL46.glDisable((int)3089);
        }
        this.recorded = false;
    }

    @Override
    public void delete() {
        this.enabled = false;
        this.recorded = false;
    }
}

