/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.accelerated.layers.storage;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.layers.LayerDrawType;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.layers.storage.ILayerContexts;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.layers.storage.ILayerStorage;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.layers.storage.SimpleLayerContexts;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.DrawContextPool;
import com.google.common.collect.Iterators;
import java.util.Iterator;

public class SeparatedLayerStorage
implements ILayerStorage {
    private final ILayerContexts[] contexts = new ILayerContexts[3];
    private final ILayerContexts opaqueContexts;
    private final ILayerContexts translucentContexts;

    public SeparatedLayerStorage(int size) {
        this.opaqueContexts = new SimpleLayerContexts(size);
        this.contexts[0] = this.translucentContexts = new SimpleLayerContexts(size);
        this.contexts[1] = this.opaqueContexts;
        this.contexts[2] = new AllContexts();
    }

    @Override
    public ILayerContexts get(LayerDrawType type) {
        return this.contexts[type.ordinal()];
    }

    @Override
    public void reset() {
        this.opaqueContexts.reset();
        this.translucentContexts.reset();
    }

    public class AllContexts
    implements ILayerContexts {
        @Override
        public void add(DrawContextPool.DrawContext drawContext) {
            throw new UnsupportedOperationException("Unsupported Operation.");
        }

        @Override
        public void reset() {
            SeparatedLayerStorage.this.opaqueContexts.reset();
            SeparatedLayerStorage.this.translucentContexts.reset();
        }

        @Override
        public void prepare() {
        }

        @Override
        public boolean isEmpty() {
            return SeparatedLayerStorage.this.opaqueContexts.isEmpty() && SeparatedLayerStorage.this.translucentContexts.isEmpty();
        }

        @Override
        public Iterator<DrawContextPool.DrawContext> iterator() {
            return Iterators.concat(SeparatedLayerStorage.this.opaqueContexts.iterator(), SeparatedLayerStorage.this.translucentContexts.iterator());
        }
    }
}

