/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools;

import com.github.argon4w.acceleratedrendering.core.backends.buffers.MappedBuffer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.ElementBufferPool;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.SimpleMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.utils.SimpleResetPool;
import com.mojang.blaze3d.vertex.VertexFormat;
import lombok.Generated;
import net.minecraft.client.renderer.RenderType;
import org.lwjgl.opengl.GL46;

public class DrawContextPool
extends SimpleResetPool<DrawContext, MappedBuffer> {
    public DrawContextPool(int size) {
        super(size, new MappedBuffer(20L * (long)size));
    }

    @Override
    protected DrawContext create(MappedBuffer buffer, int i) {
        return new DrawContext(i);
    }

    @Override
    protected void reset(DrawContext drawContext) {
    }

    @Override
    protected void delete(DrawContext drawContext) {
    }

    @Override
    public void delete() {
        ((MappedBuffer)this.getContext()).delete();
    }

    @Override
    public DrawContext fail() {
        this.expand();
        return (DrawContext)this.get();
    }

    public class DrawContext
    implements Comparable<DrawContext> {
        public static final int ELEMENT_COUNT_INDEX = 0;
        public static final IMemoryInterface INDIRECT_COUNT = new SimpleMemoryInterface(0L, 4L);
        public static final IMemoryInterface INDIRECT_INSTANCE_COUNT = new SimpleMemoryInterface(4L, 4L);
        public static final IMemoryInterface INDIRECT_FIRST_INDEX = new SimpleMemoryInterface(8L, 4L);
        public static final IMemoryInterface INDIRECT_BASE_INDEX = new SimpleMemoryInterface(12L, 4L);
        public static final IMemoryInterface INDIRECT_BASE_INSTANCE = new SimpleMemoryInterface(16L, 4L);
        private final long commandOffset;
        private RenderType renderType;

        public DrawContext(int index) {
            this.commandOffset = (long)index * 20L;
            this.renderType = null;
            long address = ((MappedBuffer)DrawContextPool.this.context).reserve(20L);
            INDIRECT_COUNT.putInt(address, 0);
            INDIRECT_INSTANCE_COUNT.putInt(address, 1);
            INDIRECT_FIRST_INDEX.putInt(address, 0);
            INDIRECT_BASE_INDEX.putInt(address, 0);
            INDIRECT_BASE_INSTANCE.putInt(address, 0);
        }

        public void bindComputeBuffers(ElementBufferPool.ElementSegment elementSegmentIn) {
            long elementOffset = elementSegmentIn.getOffset();
            long commandAddress = ((MappedBuffer)DrawContextPool.this.context).addressAt(this.commandOffset);
            INDIRECT_COUNT.putInt(commandAddress, 0);
            INDIRECT_FIRST_INDEX.putInt(commandAddress, elementOffset / 4L);
            ((MappedBuffer)DrawContextPool.this.context).bindRange(37568, 0, this.commandOffset, 4L);
        }

        public void drawElements(VertexFormat.Mode mode) {
            GL46.glDrawElementsIndirect((int)mode.f_166946_, (int)5125, (long)this.commandOffset);
        }

        @Override
        public int compareTo(DrawContext that) {
            return Boolean.compare(this.renderType.f_110393_, that.renderType.f_110393_);
        }

        @Generated
        public long getCommandOffset() {
            return this.commandOffset;
        }

        @Generated
        public RenderType getRenderType() {
            return this.renderType;
        }

        @Generated
        public void setRenderType(RenderType renderType) {
            this.renderType = renderType;
        }
    }
}

