/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.meshes;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.backends.buffers.MappedBuffer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.meshes.IMeshInfoCache;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.SimpleDynamicMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.meshes.ServerMesh;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.IUploadingShaderProgramOverride;
import com.github.argon4w.acceleratedrendering.core.utils.FastColorUtils;
import com.github.argon4w.acceleratedrendering.core.utils.SimpleResetPool;
import java.util.function.LongSupplier;
import lombok.Generated;

public class MeshUploaderPool
extends SimpleResetPool<MeshUploader, Void> {
    public MeshUploaderPool() {
        super(128, null);
    }

    @Override
    protected MeshUploader create(Void context, int i) {
        return new MeshUploader();
    }

    @Override
    protected void reset(MeshUploader meshUploader) {
        meshUploader.reset();
    }

    @Override
    protected void delete(MeshUploader meshUploader) {
        meshUploader.delete();
    }

    @Override
    public MeshUploader fail() {
        this.expand();
        return (MeshUploader)this.get();
    }

    public static class MeshUploader
    implements LongSupplier {
        public static final int MESH_INFO_BUFFER_INDEX = 8;
        public final IMemoryInterface meshInfoSharing = new SimpleDynamicMemoryInterface(0L, this);
        public final IMemoryInterface meshInfoNoCull = new SimpleDynamicMemoryInterface(4L, this);
        public final IMemoryInterface meshInfoColor = new SimpleDynamicMemoryInterface(8L, this);
        public final IMemoryInterface meshInfoOverlay = new SimpleDynamicMemoryInterface(12L, this);
        public final IMemoryInterface meshInfoLight = new SimpleDynamicMemoryInterface(16L, this);
        private final MappedBuffer meshInfoBuffer = new MappedBuffer(64L);
        private final IMeshInfoCache meshInfos = CoreFeature.createMeshInfoCache();
        private ServerMesh serverMesh = null;
        private IUploadingShaderProgramOverride uploadingOverride = null;

        public void addUpload(int color, int light, int overlay, int sharing, int shouldCull) {
            this.meshInfos.setup(color, light, overlay, sharing, shouldCull);
        }

        public void upload() {
            int meshCount = this.meshInfos.getMeshCount();
            long meshInfoAddress = this.meshInfoBuffer.reserve(this.getAsLong() * (long)meshCount);
            for (int i = 0; i < meshCount; ++i) {
                this.meshInfoSharing.at(i).putInt(meshInfoAddress, this.meshInfos.getSharing(i));
                this.meshInfoNoCull.at(i).putInt(meshInfoAddress, this.meshInfos.getShouldCull(i));
                this.meshInfoColor.at(i).putInt(meshInfoAddress, FastColorUtils.convert(this.meshInfos.getColor(i)));
                this.meshInfoOverlay.at(i).putInt(meshInfoAddress, this.meshInfos.getOverlay(i));
                this.meshInfoLight.at(i).putInt(meshInfoAddress, this.meshInfos.getLight(i));
                this.uploadingOverride.uploadMeshInfo(meshInfoAddress, i);
            }
        }

        public void bindBuffers() {
            this.meshInfoBuffer.bindBase(37074, 8);
        }

        public void reset() {
            this.meshInfos.reset();
            this.meshInfoBuffer.reset();
        }

        public void delete() {
            this.meshInfos.delete();
            this.meshInfoBuffer.delete();
        }

        @Override
        public long getAsLong() {
            return this.uploadingOverride.getMeshInfoSize();
        }

        @Generated
        public IMeshInfoCache getMeshInfos() {
            return this.meshInfos;
        }

        @Generated
        public ServerMesh getServerMesh() {
            return this.serverMesh;
        }

        @Generated
        public void setServerMesh(ServerMesh serverMesh) {
            this.serverMesh = serverMesh;
        }

        @Generated
        public IUploadingShaderProgramOverride getUploadingOverride() {
            return this.uploadingOverride;
        }

        @Generated
        public void setUploadingOverride(IUploadingShaderProgramOverride uploadingOverride) {
            this.uploadingOverride = uploadingOverride;
        }
    }
}

