/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.meshes.collectors;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.IMeshCollector;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.SimpleMeshCollector;
import com.github.argon4w.acceleratedrendering.core.meshes.data.IMeshData;
import com.github.argon4w.acceleratedrendering.core.utils.ByteBufferBuilder;
import com.github.argon4w.acceleratedrendering.core.utils.CullerUtils;
import com.github.argon4w.acceleratedrendering.core.utils.Vertex;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import net.minecraft.client.renderer.texture.OverlayTexture;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector4i;

public class CulledMeshCollector
implements VertexConsumer,
IMeshCollector {
    private final int polygonSize;
    private final NativeImage texture;
    private final IMemoryLayout<VertexFormatElement> layout;
    private final SimpleMeshCollector meshCollector;
    private final Vertex[] polygon;
    private int vertexIndex;

    public CulledMeshCollector(IAcceleratedVertexConsumer vertexConsumer) {
        this.polygonSize = vertexConsumer.getPolygonSize();
        this.texture = vertexConsumer.downloadTexture();
        this.layout = vertexConsumer.getLayout();
        this.meshCollector = new SimpleMeshCollector(this.layout);
        this.polygon = new Vertex[this.polygonSize];
        this.vertexIndex = -1;
    }

    @Override
    public void flush() {
        if (this.vertexIndex >= this.polygonSize - 1) {
            this.vertexIndex = -1;
            if (!CullerUtils.shouldCull(this.polygon, this.texture)) {
                for (Vertex vertex : this.polygon) {
                    Vector3f vertexPosition = vertex.getPosition();
                    Vector4i vertexColor = vertex.getColor();
                    Vector2f vertexUV = vertex.getUv();
                    Vector3f vertexNormal = vertex.getNormal();
                    this.meshCollector.m_5954_(vertexPosition.x, vertexPosition.y, vertexPosition.z, (float)vertexColor.x / 255.0f, (float)vertexColor.y / 255.0f, (float)vertexColor.z / 255.0f, (float)vertexColor.w / 255.0f, vertexUV.x, vertexUV.y, OverlayTexture.f_118083_, vertex.getPackedLight(), vertexNormal.x, vertexNormal.y, vertexNormal.z);
                }
            }
        }
    }

    public void m_5752_() {
        this.flush();
    }

    public void m_141991_() {
        this.meshCollector.m_141991_();
    }

    public void m_7404_(int defaultR, int defaultG, int defaultB, int defaultA) {
        this.meshCollector.m_7404_(defaultR, defaultG, defaultB, defaultA);
    }

    public VertexConsumer m_5483_(double pX, double pY, double pZ) {
        this.flush();
        this.polygon[++this.vertexIndex] = new Vertex();
        this.polygon[this.vertexIndex].getPosition().x = (float)pX;
        this.polygon[this.vertexIndex].getPosition().y = (float)pY;
        this.polygon[this.vertexIndex].getPosition().z = (float)pZ;
        return this;
    }

    public VertexConsumer m_6122_(int pRed, int pGreen, int pBlue, int pAlpha) {
        if (this.vertexIndex < 0) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.polygon[this.vertexIndex].getColor().x = pRed;
        this.polygon[this.vertexIndex].getColor().y = pGreen;
        this.polygon[this.vertexIndex].getColor().z = pBlue;
        this.polygon[this.vertexIndex].getColor().w = pAlpha;
        return this;
    }

    public VertexConsumer m_7421_(float pU, float pV) {
        if (this.vertexIndex < 0) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.polygon[this.vertexIndex].getUv().x = pU;
        this.polygon[this.vertexIndex].getUv().y = pV;
        return this;
    }

    public VertexConsumer m_7122_(int pU, int pV) {
        return this;
    }

    public VertexConsumer m_7120_(int pU, int pV) {
        if (this.vertexIndex < 0) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.polygon[this.vertexIndex].getLight().x = pU;
        this.polygon[this.vertexIndex].getLight().y = pV;
        return this;
    }

    public VertexConsumer m_5601_(float pNormalX, float pNormalY, float pNormalZ) {
        if (this.vertexIndex < 0) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.polygon[this.vertexIndex].getNormal().x = pNormalX;
        this.polygon[this.vertexIndex].getNormal().y = pNormalY;
        this.polygon[this.vertexIndex].getNormal().z = pNormalZ;
        return this;
    }

    @Override
    public IMeshData getData() {
        return this.meshCollector.getData();
    }

    @Override
    public ByteBufferBuilder getBuffer() {
        return this.meshCollector.getBuffer();
    }

    @Override
    public IMemoryLayout<VertexFormatElement> getLayout() {
        return this.meshCollector.getLayout();
    }

    @Override
    public int getVertexCount() {
        return this.meshCollector.getVertexCount();
    }
}

