/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.meshes.collectors;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.IMeshCollector;
import com.github.argon4w.acceleratedrendering.core.meshes.data.IMeshData;
import com.github.argon4w.acceleratedrendering.core.utils.ByteBufferBuilder;
import com.github.argon4w.acceleratedrendering.core.utils.PackedVector2i;
import com.github.argon4w.acceleratedrendering.core.utils.Vertex;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.DefaultedVertexConsumer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import lombok.Generated;
import net.minecraft.util.FastColor;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.joml.Vector4i;

public class SimpleMeshCollector
extends DefaultedVertexConsumer
implements IMeshCollector {
    private final IMemoryLayout<VertexFormatElement> layout;
    private final ByteBufferBuilder buffer;
    private final Vertex vertex;
    private final IMeshData data;
    private final long vertexSize;
    private final IMemoryInterface posOffset;
    private final IMemoryInterface colorOffset;
    private final IMemoryInterface uv0Offset;
    private final IMemoryInterface uv2Offset;
    private final IMemoryInterface normalOffset;
    private long vertexAddress;
    private int vertexCount;

    public SimpleMeshCollector(IMemoryLayout<VertexFormatElement> layout) {
        this.layout = layout;
        this.buffer = new ByteBufferBuilder(1024);
        this.vertex = new Vertex();
        this.data = CoreFeature.createMeshData(layout);
        this.vertexSize = this.layout.getSize();
        this.posOffset = this.layout.getElement(DefaultVertexFormat.f_85804_);
        this.colorOffset = this.layout.getElement(DefaultVertexFormat.f_85805_);
        this.uv0Offset = this.layout.getElement(DefaultVertexFormat.f_166849_);
        this.uv2Offset = this.layout.getElement(DefaultVertexFormat.f_85808_);
        this.normalOffset = this.layout.getElement(DefaultVertexFormat.f_85809_);
        this.vertexAddress = -1L;
        this.vertexCount = 0;
    }

    @Override
    public void flush() {
        this.data.addVertex(this.vertex);
    }

    public void m_5752_() {
    }

    public VertexConsumer m_5483_(double pX, double pY, double pZ) {
        if (this.vertexCount != 0) {
            this.data.addVertex(this.vertex);
        }
        ++this.vertexCount;
        this.vertexAddress = this.buffer.reserve((int)this.vertexSize);
        this.posOffset.putFloat(this.vertexAddress + 0L, (float)pX);
        this.posOffset.putFloat(this.vertexAddress + 4L, (float)pY);
        this.posOffset.putFloat(this.vertexAddress + 8L, (float)pZ);
        Vector3f vertexPosition = this.vertex.getPosition();
        vertexPosition.x = (float)pX;
        vertexPosition.y = (float)pY;
        vertexPosition.z = (float)pZ;
        return this;
    }

    public VertexConsumer m_6122_(int pRed, int pGreen, int pBlue, int pAlpha) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        if (this.f_85824_) {
            pRed = this.f_85825_;
            pGreen = this.f_85826_;
            pBlue = this.f_85827_;
            pAlpha = this.f_85828_;
        }
        this.colorOffset.putByte(this.vertexAddress + 0L, (byte)pRed);
        this.colorOffset.putByte(this.vertexAddress + 1L, (byte)pGreen);
        this.colorOffset.putByte(this.vertexAddress + 2L, (byte)pBlue);
        this.colorOffset.putByte(this.vertexAddress + 3L, (byte)pAlpha);
        Vector4i vertexColor = this.vertex.getColor();
        vertexColor.x = pRed;
        vertexColor.y = pGreen;
        vertexColor.z = pBlue;
        vertexColor.w = pAlpha;
        return this;
    }

    public VertexConsumer m_7421_(float pU, float pV) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.uv0Offset.putFloat(this.vertexAddress + 0L, pU);
        this.uv0Offset.putFloat(this.vertexAddress + 4L, pV);
        Vector2f vertexUv = this.vertex.getUv();
        vertexUv.x = pU;
        vertexUv.y = pV;
        return this;
    }

    public VertexConsumer m_7122_(int pU, int pV) {
        return this;
    }

    public VertexConsumer m_7120_(int pU, int pV) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.uv2Offset.putShort(this.vertexAddress + 0L, (short)pU);
        this.uv2Offset.putShort(this.vertexAddress + 2L, (short)pV);
        Vector2i vertexLight = this.vertex.getLight();
        vertexLight.x = pU;
        vertexLight.y = pV;
        return this;
    }

    public VertexConsumer m_5601_(float pNormalX, float pNormalY, float pNormalZ) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.normalOffset.putNormal(this.vertexAddress + 0L, pNormalX);
        this.normalOffset.putNormal(this.vertexAddress + 1L, pNormalY);
        this.normalOffset.putNormal(this.vertexAddress + 2L, pNormalZ);
        Vector3f vertexNormal = this.vertex.getNormal();
        vertexNormal.x = pNormalX;
        vertexNormal.y = pNormalY;
        vertexNormal.z = pNormalZ;
        return this;
    }

    public void m_5954_(float pX, float pY, float pZ, float red, float green, float blue, float alpha, float pU, float pV, int pPackedOverlay, int pPackedLight, float pNormalX, float pNormalY, float pNormalZ) {
        if (this.f_85824_) {
            red = (float)this.f_85825_ / 255.0f;
            green = (float)this.f_85826_ / 255.0f;
            blue = (float)this.f_85827_ / 255.0f;
            alpha = (float)this.f_85828_ / 255.0f;
        }
        ++this.vertexCount;
        this.vertexAddress = this.buffer.reserve((int)this.vertexSize);
        this.posOffset.putFloat(this.vertexAddress + 0L, pX);
        this.posOffset.putFloat(this.vertexAddress + 4L, pY);
        this.posOffset.putFloat(this.vertexAddress + 8L, pZ);
        this.colorOffset.putInt(this.vertexAddress, FastColor.ABGR32.m_266248_((int)((int)(alpha * 255.0f)), (int)((int)(blue * 255.0f)), (int)((int)(green * 255.0f)), (int)((int)(red * 255.0f))));
        this.uv0Offset.putFloat(this.vertexAddress + 0L, pU);
        this.uv0Offset.putFloat(this.vertexAddress + 4L, pV);
        this.uv2Offset.putInt(this.vertexAddress, pPackedLight);
        this.normalOffset.putNormal(this.vertexAddress + 0L, pNormalX);
        this.normalOffset.putNormal(this.vertexAddress + 1L, pNormalY);
        this.normalOffset.putNormal(this.vertexAddress + 2L, pNormalZ);
        this.data.addVertex(pX, pY, pZ, pU, pV, (int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f), PackedVector2i.unpackU(pPackedLight), PackedVector2i.unpackV(pPackedLight), pNormalX, pNormalY, pNormalZ);
    }

    @Override
    @Generated
    public IMemoryLayout<VertexFormatElement> getLayout() {
        return this.layout;
    }

    @Override
    @Generated
    public ByteBufferBuilder getBuffer() {
        return this.buffer;
    }

    @Generated
    public Vertex getVertex() {
        return this.vertex;
    }

    @Override
    @Generated
    public IMeshData getData() {
        return this.data;
    }

    @Generated
    public long getVertexAddress() {
        return this.vertexAddress;
    }

    @Override
    @Generated
    public int getVertexCount() {
        return this.vertexCount;
    }
}

