/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.items.mixins.models;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IBufferGraph;
import com.github.argon4w.acceleratedrendering.core.meshes.IMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.CulledMeshCollector;
import com.github.argon4w.acceleratedrendering.core.meshes.data.IMeshData;
import com.github.argon4w.acceleratedrendering.core.utils.ByteBufferBuilder;
import com.github.argon4w.acceleratedrendering.core.utils.IntArrayHashStrategy;
import com.github.argon4w.acceleratedrendering.features.entities.AcceleratedEntityRenderingFeature;
import com.github.argon4w.acceleratedrendering.features.items.IAcceleratedBakedQuad;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.FastColor;
import net.minecraftforge.client.model.IQuadTransformer;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BakedQuad.class})
public abstract class BakedQuadMixin
implements IAcceleratedBakedQuad {
    @Unique
    private static final Map<int[], Map<IBufferGraph, IMesh>> MESHES = new Object2ObjectOpenCustomHashMap((Hash.Strategy)IntArrayHashStrategy.INSTANCE);
    @Unique
    private static final Map<int[], Map<IMeshData, IMesh>> MERGES = new Object2ObjectOpenCustomHashMap((Hash.Strategy)IntArrayHashStrategy.INSTANCE);
    @Shadow
    @Final
    protected int[] f_111292_;

    @Shadow
    public abstract boolean m_111304_();

    @Override
    @Unique
    public void renderFast(Matrix4f transform, Matrix3f normal, IAcceleratedVertexConsumer extension, int combinedLight, int combinedOverlay, int color) {
        IMesh mesh;
        Object2ObjectOpenHashMap meshes = MESHES.get(this.f_111292_);
        Object2ObjectOpenHashMap merges = MERGES.get(this.f_111292_);
        if (meshes == null) {
            meshes = new Object2ObjectOpenHashMap();
            merges = new Object2ObjectOpenHashMap();
            MESHES.put(this.f_111292_, (Map<IBufferGraph, IMesh>)meshes);
            MERGES.put(this.f_111292_, (Map<IMeshData, IMesh>)merges);
        }
        if ((mesh = meshes.get(extension)) != null) {
            mesh.write(extension, this.getCustomColor(color), combinedLight, combinedOverlay);
            return;
        }
        CulledMeshCollector culledMeshCollector = new CulledMeshCollector(extension);
        VertexConsumer meshBuilder = extension.decorate(culledMeshCollector);
        for (int i = 0; i < this.f_111292_.length / 8; ++i) {
            int vertexOffset = i * IQuadTransformer.STRIDE;
            int posOffset = vertexOffset + IQuadTransformer.POSITION;
            int colorOffset = vertexOffset + IQuadTransformer.COLOR;
            int uv0Offset = vertexOffset + IQuadTransformer.UV0;
            int uv2Offset = vertexOffset + IQuadTransformer.UV2;
            int normalOffset = vertexOffset + IQuadTransformer.NORMAL;
            int packedNormal = this.f_111292_[normalOffset];
            int packedColor = this.f_111292_[colorOffset];
            meshBuilder.m_5954_(Float.intBitsToFloat(this.f_111292_[posOffset + 0]), Float.intBitsToFloat(this.f_111292_[posOffset + 1]), Float.intBitsToFloat(this.f_111292_[posOffset + 2]), (float)FastColor.ARGB32.m_13665_((int)packedColor) / 255.0f, (float)FastColor.ARGB32.m_13667_((int)packedColor) / 255.0f, (float)FastColor.ARGB32.m_13669_((int)packedColor) / 255.0f, (float)FastColor.ARGB32.m_13655_((int)packedColor) / 255.0f, Float.intBitsToFloat(this.f_111292_[uv0Offset + 0]), Float.intBitsToFloat(this.f_111292_[uv0Offset + 1]), combinedOverlay, this.f_111292_[uv2Offset], (float)((byte)(packedNormal & 0xFF)) / 127.0f, (float)((byte)(packedNormal >> 8 & 0xFF)) / 127.0f, (float)((byte)(packedNormal >> 16 & 0xFF)) / 127.0f);
        }
        culledMeshCollector.flush();
        IMeshData data = culledMeshCollector.getData();
        ByteBufferBuilder buffer = culledMeshCollector.getBuffer();
        mesh = (IMesh)merges.get(data);
        if (mesh != null) {
            buffer.close();
        } else {
            mesh = AcceleratedEntityRenderingFeature.getMeshType().getBuilder().build(culledMeshCollector);
        }
        meshes.put(extension, mesh);
        merges.put(data, mesh);
        mesh.write(extension, this.getCustomColor(color), combinedLight, combinedOverlay);
    }

    @Override
    @Unique
    public int getCustomColor(int color) {
        return this.m_111304_() ? color : -1;
    }
}

