/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.items.mixins.models;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.features.items.BakedModelExtension;
import com.github.argon4w.acceleratedrendering.features.items.IAcceleratedBakedModel;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.WeightedBakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WeightedBakedModel.class})
public class WeightedBakedModelMixin
implements IAcceleratedBakedModel {
    @Unique
    private boolean accelerated;
    @Unique
    private boolean acceleratedInHand;
    @Unique
    private boolean acceleratedInGui;
    @Shadow
    @Final
    private List<WeightedEntry.Wrapper<BakedModel>> f_119541_;
    @Shadow
    @Final
    private int f_119540_;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void checkAccelerationSupport(List<WeightedEntry.Wrapper<BakedModel>> list, CallbackInfo ci) {
        this.accelerated = true;
        this.acceleratedInHand = true;
        this.acceleratedInGui = true;
        for (WeightedEntry.Wrapper<BakedModel> wrapper : list) {
            IAcceleratedBakedModel extension = BakedModelExtension.getAccelerated((BakedModel)wrapper.m_146310_());
            this.accelerated &= extension.isAccelerated();
            this.acceleratedInHand &= extension.isAcceleratedInHand();
            this.acceleratedInGui &= extension.isAcceleratedInGui();
        }
    }

    @Override
    public void renderItemFast(ItemStack itemStack, RandomSource random, PoseStack.Pose pose, IAcceleratedVertexConsumer extension, int light, int overlay) {
        Optional model = WeightedRandom.m_146314_(this.f_119541_, (int)(Math.abs((int)random.m_188505_()) % this.f_119540_));
        if (model.isPresent()) {
            BakedModelExtension.getAccelerated((BakedModel)((WeightedEntry.Wrapper)model.get()).m_146310_()).renderItemFast(itemStack, random, pose, extension, light, overlay);
        }
    }

    @Override
    public void renderBlockFast(BlockState state, RandomSource random, PoseStack.Pose pose, IAcceleratedVertexConsumer extension, int light, int overlay, int color, ModelData data, RenderType renderType) {
        Optional model = WeightedRandom.m_146314_(this.f_119541_, (int)(Math.abs((int)random.m_188505_()) % this.f_119540_));
        if (model.isPresent()) {
            BakedModelExtension.getAccelerated((BakedModel)((WeightedEntry.Wrapper)model.get()).m_146310_()).renderBlockFast(state, random, pose, extension, light, overlay, this.getCustomColor(-1, color), data, renderType);
        }
    }

    @Override
    public int getCustomColor(int layer, int color) {
        return color;
    }

    @Override
    @Generated
    public boolean isAccelerated() {
        return this.accelerated;
    }

    @Override
    @Generated
    public boolean isAcceleratedInHand() {
        return this.acceleratedInHand;
    }

    @Override
    @Generated
    public boolean isAcceleratedInGui() {
        return this.acceleratedInGui;
    }

    @Generated
    public List<WeightedEntry.Wrapper<BakedModel>> getList() {
        return this.f_119541_;
    }

    @Generated
    public int getTotalWeight() {
        return this.f_119540_;
    }
}

