/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.touhoulittlemaid.mixins;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IBufferGraph;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import com.github.argon4w.acceleratedrendering.core.meshes.IMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.CulledMeshCollector;
import com.github.argon4w.acceleratedrendering.core.meshes.data.IMeshData;
import com.github.argon4w.acceleratedrendering.core.utils.ByteBufferBuilder;
import com.github.argon4w.acceleratedrendering.features.entities.AcceleratedEntityRenderingFeature;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoMesh;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Pseudo
@Mixin(value={GeoBone.class})
public class GeoBoneMixin
implements IAcceleratedRenderer<Void> {
    @Shadow(remap=false)
    @Final
    private GeoMesh cubes;
    @Unique
    private final Map<IBufferGraph, IMesh> meshes = new Object2ObjectOpenHashMap();
    @Unique
    private final Map<IMeshData, IMesh> merges = new Object2ObjectOpenHashMap();

    @Override
    @Unique
    public void render(VertexConsumer vertexConsumer, Void context, Matrix4f transformMatrix, Matrix3f normalMatrix, int light, int overlay, int color) {
        IAcceleratedVertexConsumer extension = VertexConsumerExtension.getAccelerated(vertexConsumer);
        IMesh mesh = this.meshes.get(extension);
        extension.beginTransform(transformMatrix, normalMatrix);
        if (mesh != null) {
            mesh.write(extension, color, light, overlay);
            extension.endTransform();
            return;
        }
        CulledMeshCollector culledMeshCollector = new CulledMeshCollector(extension);
        VertexConsumer meshBuilder = extension.decorate(culledMeshCollector);
        for (int i = 0; i < this.cubes.getCubeCount(); ++i) {
            boolean mirrored;
            Vector3f deltaX = new Vector3f((Vector3fc)this.cubes.dx(i));
            Vector3f deltaY = new Vector3f((Vector3fc)this.cubes.dy(i));
            Vector3f deltaZ = new Vector3f((Vector3fc)this.cubes.dz(i));
            Vector3f p000 = new Vector3f((Vector3fc)this.cubes.position(i));
            Vector3f p100 = p000.add((Vector3fc)deltaX, new Vector3f());
            Vector3f p110 = p100.add((Vector3fc)deltaY, new Vector3f());
            Vector3f p010 = p000.add((Vector3fc)deltaY, new Vector3f());
            Vector3f p001 = p000.add((Vector3fc)deltaZ, new Vector3f());
            Vector3f p101 = p100.add((Vector3fc)deltaZ, new Vector3f());
            Vector3f p111 = p110.add((Vector3fc)deltaZ, new Vector3f());
            Vector3f p011 = p010.add((Vector3fc)deltaZ, new Vector3f());
            Vector3f positiveNormalZ = deltaX.cross((Vector3fc)deltaY, new Vector3f()).normalize();
            Vector3f positiveNormalX = deltaY.cross((Vector3fc)deltaZ, new Vector3f()).normalize();
            Vector3f positiveNormalY = deltaZ.cross((Vector3fc)deltaX, new Vector3f()).normalize();
            int faces = this.cubes.faces(i);
            boolean bl = mirrored = (faces & 0x40) != 0;
            if (mirrored) {
                positiveNormalX.mul(-1.0f);
                positiveNormalY.mul(-1.0f);
                positiveNormalZ.mul(-1.0f);
            }
            Vector3f negativeNormalX = positiveNormalX.negate(new Vector3f());
            Vector3f negativeNormalY = positiveNormalY.negate(new Vector3f());
            Vector3f negativeNormalZ = positiveNormalZ.negate(new Vector3f());
            Vector3f[][] positions = new Vector3f[][]{{p101, p001, p000, p100}, {p110, p010, p011, p111}, {p100, p000, p010, p110}, {p001, p101, p111, p011}, {p101, p100, p110, p111}, {p000, p001, p011, p010}};
            float[][] texCoords = new float[][]{{this.cubes.downU0(i), this.cubes.downU1(i), this.cubes.downV0(i), this.cubes.downV1(i)}, {this.cubes.upU0(i), this.cubes.upU1(i), this.cubes.upV0(i), this.cubes.upV1(i)}, {this.cubes.northU0(i), this.cubes.northU1(i), this.cubes.northV0(i), this.cubes.northV1(i)}, {this.cubes.southU0(i), this.cubes.southU1(i), this.cubes.southV0(i), this.cubes.southV1(i)}, {this.cubes.eastU0(i), this.cubes.eastU1(i), this.cubes.eastV0(i), this.cubes.eastV1(i)}, {this.cubes.westU0(i), this.cubes.westU1(i), this.cubes.westV0(i), this.cubes.westV1(i)}};
            Vector2i[] texOrders = new Vector2i[]{new Vector2i(0, 3), new Vector2i(1, 3), new Vector2i(1, 2), new Vector2i(0, 2)};
            Vector3f[] normals = new Vector3f[]{negativeNormalY, positiveNormalY, negativeNormalZ, positiveNormalZ, positiveNormalX, negativeNormalX};
            for (int j = 0; j < 6; ++j) {
                if ((faces & 1 << j) == 0) continue;
                for (int k = 0; k < 4; ++k) {
                    Vector3f position = positions[j][k];
                    float[] texCoord = texCoords[j];
                    Vector2i texOrder = texOrders[k];
                    Vector3f normal = normals[j];
                    meshBuilder.m_5954_(position.x, position.y, position.z, 1.0f, 1.0f, 1.0f, 1.0f, texCoord[texOrder.x], texCoord[texOrder.y], overlay, 0, normal.x, normal.y, normal.z);
                }
            }
        }
        culledMeshCollector.flush();
        IMeshData data = culledMeshCollector.getData();
        ByteBufferBuilder buffer = culledMeshCollector.getBuffer();
        mesh = this.merges.get(data);
        if (mesh != null) {
            buffer.close();
        } else {
            mesh = AcceleratedEntityRenderingFeature.getMeshType().getBuilder().build(culledMeshCollector);
        }
        this.meshes.put(extension, mesh);
        this.merges.put(data, mesh);
        mesh.write(extension, color, light, overlay);
        extension.endTransform();
    }
}

