/*
 * Decompiled with CFR 0.152.
 */
package ziyue.bde.mixin;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Creeper.class})
public abstract class CreeperMixin
extends Monster {
    @Shadow
    @Final
    private static EntityDataAccessor<Integer> DATA_SWELL_DIR;
    @Shadow
    @Final
    private static EntityDataAccessor<Boolean> DATA_IS_POWERED;
    @Shadow
    @Final
    private static EntityDataAccessor<Boolean> DATA_IS_IGNITED;
    @Shadow
    private int oldSwell;
    @Shadow
    private int swell;
    @Unique
    private static final EntityDataAccessor<Boolean> DATA_NEUTRALIZED;

    @Shadow
    public abstract void setTarget(@Nullable LivingEntity var1);

    protected CreeperMixin(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
    }

    @Inject(at={@At(value="TAIL")}, method={"defineSynchedData"})
    private void afterDefineSynchedData(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(DATA_NEUTRALIZED, (Object)false);
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData"})
    private void afterAddAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        tag.putBoolean("neutralized", ((Boolean)this.entityData.get(DATA_NEUTRALIZED)).booleanValue());
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData"})
    private void afterReadAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        this.entityData.set(DATA_NEUTRALIZED, (Object)tag.getBoolean("neutralized").orElse(false));
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"}, cancellable=true)
    private void beforeTick(CallbackInfo ci) {
        if (((Boolean)this.entityData.get(DATA_NEUTRALIZED)).booleanValue()) {
            super.tick();
            ci.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"mobInteract"}, cancellable=true)
    private void beforeMobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (((Boolean)this.entityData.get(DATA_NEUTRALIZED)).booleanValue()) {
            if (itemstack.is(Items.GUNPOWDER)) {
                itemstack.setCount(itemstack.getCount() - 1);
                this.playSound(SoundEvents.GRASS_PLACE);
                this.entityData.set(DATA_NEUTRALIZED, (Object)false);
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
                return;
            }
            cir.setReturnValue((Object)InteractionResult.PASS);
            return;
        }
        if (player.isHolding(Items.SHEARS)) {
            this.playSound(SoundEvents.SHEEP_SHEAR);
            if (!this.level().isClientSide()) {
                this.spawnAtLocation((ServerLevel)this.level(), new ItemStack((ItemLike)Items.GUNPOWDER));
            }
            itemstack.hurtAndBreak(1, (LivingEntity)player, CreeperMixin.getSlotForHand((InteractionHand)hand));
            this.setTarget(null);
            this.entityData.set(DATA_NEUTRALIZED, (Object)true);
            this.entityData.set(DATA_SWELL_DIR, (Object)-1);
            this.entityData.set(DATA_IS_POWERED, (Object)false);
            this.entityData.set(DATA_IS_IGNITED, (Object)false);
            this.swell = 0;
            this.oldSwell = 0;
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"setTarget"}, cancellable=true)
    private void beforeSetTarget(LivingEntity entity, CallbackInfo ci) {
        if (((Boolean)this.entityData.get(DATA_NEUTRALIZED)).booleanValue() && entity instanceof Player) {
            ci.cancel();
        }
    }

    static {
        DATA_NEUTRALIZED = SynchedEntityData.defineId(CreeperMixin.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    }
}

