/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.pccompat;

import covers1624.powerconverters.api.registry.PowerSystemRegistry;
import covers1624.powerconverters.init.PowerSystems;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.lang.reflect.Field;
import java.util.HashSet;
import net.anvilcraft.pccompat.IModProxy;
import net.anvilcraft.pccompat.mods.AppliedEnergisticsProxy;
import net.anvilcraft.pccompat.mods.ElectriCraftProxy;
import net.anvilcraft.pccompat.mods.GregTechProxy;
import net.anvilcraft.pccompat.mods.HBMProxy;
import net.anvilcraft.pccompat.mods.MagneticraftProxy;
import net.anvilcraft.pccompat.mods.ProjectRedProxy;
import net.anvilcraft.pccompat.mods.RailcraftProxy;
import net.anvilcraft.pccompat.mods.RedPowerProxy;
import net.anvilcraft.pccompat.mods.UltraTechProxy;
import net.anvilcraft.pccompat.mods.UniversalElectricityProxy;

@Mod(modid="pccompat", name="PC Compat", version="0.1.0", dependencies="required-after:PowerConverters3;after:basiccomponents;after:appliedenergistics2;after:hbm;after:RedPowerCore;after:ProjRed|Expansion;after:gregtech;after:UltraTech;after:Railcraft;after:Magneticraft;after:ElectriCraft")
public class PCCompat {
    public static HashSet<IModProxy> mods = new HashSet();

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent ev) {
        PCCompat.collectMods();
        try {
            Field field = PowerSystemRegistry.PowerSystem.class.getDeclaredField("scaleAmmount");
            field.setAccessible(true);
            field.setInt(PowerSystems.powerSystemIndustrialCraft, 4000);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (IModProxy mp : mods) {
            mp.registerPowerSystem();
            mp.registerBlocks();
            mp.registerTiles();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent ev) {
        for (IModProxy mp : mods) {
            mp.registerRecipes();
        }
    }

    private static void collectMods() {
        if (Loader.isModLoaded((String)"basiccomponents")) {
            mods.add(new UniversalElectricityProxy());
        }
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            mods.add(new AppliedEnergisticsProxy());
        }
        if (Loader.isModLoaded((String)"hbm")) {
            mods.add(new HBMProxy());
        }
        if (Loader.isModLoaded((String)"RedPowerCore")) {
            mods.add(new RedPowerProxy());
        }
        if (Loader.isModLoaded((String)"ProjRed|Expansion")) {
            mods.add(new ProjectRedProxy());
        }
        if (Loader.isModLoaded((String)"gregtech")) {
            mods.add(new GregTechProxy());
        }
        if (Loader.isModLoaded((String)"UltraTech")) {
            mods.add(new UltraTechProxy());
        }
        if (Loader.isModLoaded((String)"Railcraft")) {
            mods.add(new RailcraftProxy());
        }
        if (Loader.isModLoaded((String)"Magneticraft")) {
            mods.add(new MagneticraftProxy());
        }
        if (Loader.isModLoaded((String)"ElectriCraft")) {
            mods.add(new ElectriCraftProxy());
        }
    }
}

