/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.pccompat;

import covers1624.powerconverters.tile.main.TileEntityEnergyBridge;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.anvilcraft.pccompat.recipe.RecipeBuilder;
import net.anvilcraft.pccompat.recipe.ShapelessOreRecipeAdapter;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class Utils {
    public static void registerStandardPowerConverterBlockIcons(IIconRegister reg, IIcon[] icons, String modPrefix) {
        for (int i = 0; i < 4; ++i) {
            String state = i % 2 == 0 ? "off" : "on";
            String type = i < 2 ? "consumer" : "producer";
            icons[i] = reg.func_94245_a("pccompat:" + modPrefix + "_" + type + "_" + state);
        }
    }

    public static void registerConversionRecipes(Block block, int metaA, int metaB) {
        ItemStack stackA = new ItemStack(block, 1, metaA);
        ItemStack stackB = new ItemStack(block, 1, metaB);
        new RecipeBuilder(new ShapelessOreRecipeAdapter()).ingredient(stackA).output(stackB).register();
        new RecipeBuilder(new ShapelessOreRecipeAdapter()).ingredient(stackB).output(stackA).register();
    }

    public static Map<ForgeDirection, Double> getOutputRates(TileEntityEnergyBridge bridge) {
        try {
            Field rates = TileEntityEnergyBridge.class.getDeclaredField("_producerOutputRates");
            rates.setAccessible(true);
            Object value = rates.get(bridge);
            return (Map)value;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
            return new HashMap<ForgeDirection, Double>();
        }
    }

    public static ForgeDirection getSide(TileEntity reference, TileEntity target) {
        if (reference.field_145851_c > target.field_145851_c && reference.field_145848_d == target.field_145848_d && reference.field_145849_e == target.field_145849_e) {
            return ForgeDirection.WEST;
        }
        if (reference.field_145851_c < target.field_145851_c && reference.field_145848_d == target.field_145848_d && reference.field_145849_e == target.field_145849_e) {
            return ForgeDirection.EAST;
        }
        if (reference.field_145851_c == target.field_145851_c && reference.field_145848_d > target.field_145848_d && reference.field_145849_e == target.field_145849_e) {
            return ForgeDirection.DOWN;
        }
        if (reference.field_145851_c == target.field_145851_c && reference.field_145848_d < target.field_145848_d && reference.field_145849_e == target.field_145849_e) {
            return ForgeDirection.UP;
        }
        if (reference.field_145851_c == target.field_145851_c && reference.field_145848_d == target.field_145848_d && reference.field_145849_e > target.field_145849_e) {
            return ForgeDirection.NORTH;
        }
        if (reference.field_145851_c == target.field_145851_c && reference.field_145848_d == target.field_145848_d && reference.field_145849_e < target.field_145849_e) {
            return ForgeDirection.SOUTH;
        }
        return ForgeDirection.UNKNOWN;
    }
}

