/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.pccompat.mods;

import basiccomponents.common.BasicComponents;
import covers1624.powerconverters.api.registry.PowerSystemRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import net.anvilcraft.pccompat.IModProxy;
import net.anvilcraft.pccompat.Utils;
import net.anvilcraft.pccompat.blocks.BlockPowerConverterUniversalElectricity;
import net.anvilcraft.pccompat.items.ItemBlockPowerConverter;
import net.anvilcraft.pccompat.recipe.RecipeBuilder;
import net.anvilcraft.pccompat.recipe.ShapedOreRecipeAdapter;
import net.anvilcraft.pccompat.tiles.TileEntityUniversalElectricityConsumer;
import net.anvilcraft.pccompat.tiles.TileEntityUniversalElectricityProducer;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class UniversalElectricityProxy
implements IModProxy {
    public static PowerSystemRegistry.PowerSystem powerSystem;
    public static Block blockPowerConverter;

    @Override
    public void registerPowerSystem() {
        powerSystem = new PowerSystemRegistry.PowerSystem("Universal Electricity", "UE", 400, new String[]{"LV", "MV", "HV", "EV"}, new int[]{60, 120, 240, 480}, "W");
        PowerSystemRegistry.registerPowerSystem((PowerSystemRegistry.PowerSystem)powerSystem);
    }

    @Override
    public void registerBlocks() {
        blockPowerConverter = new BlockPowerConverterUniversalElectricity(this);
        GameRegistry.registerBlock((Block)blockPowerConverter, ItemBlockPowerConverter.class, (String)"power_converter_universal_electrictity");
    }

    @Override
    public void registerTiles() {
        GameRegistry.registerTileEntity(TileEntityUniversalElectricityConsumer.class, (String)"universal_electricity_consumer");
        GameRegistry.registerTileEntity(TileEntityUniversalElectricityProducer.class, (String)"universal_electricity_producer");
    }

    @Override
    public void registerRecipes() {
        ItemStack batbox = new ItemStack(BasicComponents.blockMachine, 1, 4);
        new RecipeBuilder(new ShapedOreRecipeAdapter()).pattern("G G", "   ", "GBG").ingredient(Character.valueOf('G'), "ingotGold").ingredient(Character.valueOf('B'), batbox).output(new ItemStack(blockPowerConverter, 1, 0)).register();
        new RecipeBuilder(new ShapedOreRecipeAdapter()).pattern("G G", " B ", "G G").ingredient(Character.valueOf('G'), "ingotGold").ingredient(Character.valueOf('B'), batbox).output(new ItemStack(blockPowerConverter, 1, 2)).register();
        new RecipeBuilder(new ShapedOreRecipeAdapter()).pattern("GBG", "   ", "G G").ingredient(Character.valueOf('G'), "ingotGold").ingredient(Character.valueOf('B'), batbox).output(new ItemStack(blockPowerConverter, 1, 4)).register();
        new RecipeBuilder(new ShapedOreRecipeAdapter()).pattern("GBG", "G G", "G G").ingredient(Character.valueOf('G'), "ingotGold").ingredient(Character.valueOf('B'), batbox).output(new ItemStack(blockPowerConverter, 1, 6)).register();
        for (int i = 0; i < 8; i += 2) {
            Utils.registerConversionRecipes(blockPowerConverter, i, i + 1);
        }
    }

    @Override
    public int getMetaCount() {
        return 8;
    }

    @Override
    public String getModPrefix() {
        return "ue";
    }

    @Override
    public TileEntity createTileEntity(int meta) {
        return meta % 2 != 0 ? new TileEntityUniversalElectricityProducer(meta / 2) : new TileEntityUniversalElectricityConsumer(meta / 2);
    }
}

