/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.pccompat.tiles;

import appeng.api.config.Actionable;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import covers1624.powerconverters.tile.main.TileEntityEnergyProducer;
import net.anvilcraft.pccompat.mods.AppliedEnergisticsProxy;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityAppliedEnergisticsProducer
extends TileEntityEnergyProducer<IGridHost>
implements IGridProxyable {
    private AENetworkProxy proxy = new AENetworkProxy((IGridProxyable)this, "proxy", new ItemStack(AppliedEnergisticsProxy.blockPowerConverter, 1, 1), true);
    private boolean init = false;

    public TileEntityAppliedEnergisticsProducer() {
        super(AppliedEnergisticsProxy.powerSystem, 0, IGridHost.class);
        this.proxy.setIdlePowerUsage(0.0);
    }

    public double produceEnergy(double energy) {
        double ae = energy / (double)this.getPowerSystem().getScaleAmmount();
        try {
            IEnergyGrid grid = this.getProxy().getEnergy();
            double toInject = Math.min(Math.min(ae, grid.getEnergyDemand(ae)), 10000.0);
            ae -= toInject;
            grid.injectPower(toInject, Actionable.MODULATE);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return MathHelper.func_76128_c((double)(ae * (double)this.getPowerSystem().getScaleAmmount()));
    }

    public IGridNode getGridNode(ForgeDirection dir) {
        return this.getProxy().getNode();
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.GLASS;
    }

    public void securityBreak() {
        this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, true);
    }

    public AENetworkProxy getProxy() {
        return this.proxy;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public void gridChanged() {
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.getProxy().readFromNBT(tagCompound);
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.getProxy().writeToNBT(tagCompound);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.getProxy().onChunkUnload();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.getProxy().invalidate();
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.getProxy().validate();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.init) {
            this.init = true;
            this.getProxy().onReady();
        }
    }
}

