/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.pccompat.tiles;

import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.ElectriCraft.Auxiliary.Interfaces.NetworkTile;
import Reika.ElectriCraft.Auxiliary.Interfaces.WireEmitter;
import Reika.ElectriCraft.Network.WireNetwork;
import covers1624.powerconverters.tile.main.TileEntityEnergyProducer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.anvilcraft.pccompat.mods.ElectriCraftProxy;
import net.anvilcraft.pccompat.tiles.ITileNeighborNotify;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityElectriCraftProducer
extends TileEntityEnergyProducer<NetworkTile>
implements WireEmitter,
ITileNeighborNotify {
    public static final int VOLTAGE = 2048;
    public static final int AMPERAGE = 128;
    public WireNetwork network;
    public boolean emitLastTick;
    public boolean hasSufficientPower;

    public TileEntityElectriCraftProducer() {
        super(ElectriCraftProxy.powerSystem, 0, NetworkTile.class);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.network == null) {
            this.findAndJoinNetwork(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return;
        }
        boolean emit = this.canEmitPower();
        if (emit != this.emitLastTick) {
            this.network.updateWires();
        }
        this.emitLastTick = emit;
    }

    public boolean canNetworkOnSide(ForgeDirection arg0) {
        return true;
    }

    public void findAndJoinNetwork(World arg0, int arg1, int arg2, int arg3) {
        this.network = new WireNetwork();
        this.network.addElement((NetworkTile)this);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            WireNetwork w;
            NetworkTile n;
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (!(te instanceof NetworkTile) || !(n = (NetworkTile)te).canNetworkOnSide(dir.getOpposite()) || (w = n.getNetwork()) == null) continue;
            w.merge(this.network);
        }
    }

    public WireNetwork getNetwork() {
        return this.network;
    }

    public World getWorld() {
        return this.field_145850_b;
    }

    public int getX() {
        return this.field_145851_c;
    }

    public int getY() {
        return this.field_145848_d;
    }

    public int getZ() {
        return this.field_145849_e;
    }

    public boolean isConnectable() {
        return true;
    }

    public void onNetworkChanged() {
    }

    public void removeFromNetwork() {
        if (this.network != null) {
            try {
                Field sinksField = WireNetwork.class.getDeclaredField("sources");
                sinksField.setAccessible(true);
                HashMap sinks = (HashMap)sinksField.get(this.network);
                sinks.remove(new WorldLocation((TileEntity)this));
                Method rebuild = WireNetwork.class.getDeclaredMethod("rebuild", new Class[0]);
                rebuild.setAccessible(true);
                rebuild.invoke((Object)this.network, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public void resetNetwork() {
        this.network = null;
    }

    public final void rebuildNetwork() {
        this.removeFromNetwork();
        this.resetNetwork();
        this.findAndJoinNetwork(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setNetwork(WireNetwork net) {
        if (net != null) {
            this.network = net;
            this.network.addElement((NetworkTile)this);
        }
    }

    public boolean isReadyToEmitPower() {
        return this.network != null && this.network.getNumberPathsStartingAt((WireEmitter)this) > 0;
    }

    public boolean canEmitPower() {
        return this.isReadyToEmitPower() && this.hasSufficientPower;
    }

    public boolean canEmitPowerToSide(ForgeDirection arg0) {
        return true;
    }

    public int getGenCurrent() {
        return this.canEmitPower() ? 128 : 0;
    }

    public int getGenVoltage() {
        return this.canEmitPower() ? 2048 : 0;
    }

    public double produceEnergy(double energy) {
        double avail = energy / 5.6;
        if (!this.isReadyToEmitPower() || avail < 262144.0) {
            this.hasSufficientPower = false;
            return energy;
        }
        this.hasSufficientPower = true;
        return energy - 1468006.4;
    }

    @Override
    public void onNeighborTEChange() {
        this.rebuildNetwork();
    }
}

