/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.pccompat.tiles;

import covers1624.powerconverters.tile.main.TileEntityEnergyBridge;
import covers1624.powerconverters.tile.main.TileEntityEnergyConsumer;
import gregtech.api.interfaces.tileentity.IBasicEnergyContainer;
import gregtech.api.interfaces.tileentity.IEnergyConnected;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_Utility;
import net.anvilcraft.pccompat.mods.GregTechProxy;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityGregTechConsumer
extends TileEntityEnergyConsumer<IEnergyConnected>
implements IBasicEnergyContainer {
    private long lastTransfer;
    private boolean transferLastTick;
    private boolean dead;
    private long acceptedAmperes;

    public TileEntityGregTechConsumer(int voltageNameIndex) {
        super(GregTechProxy.powerSystem, voltageNameIndex, IEnergyConnected.class);
    }

    public double getInputRate() {
        return this.lastTransfer;
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.dead = false;
        this.acceptedAmperes = 0L;
        if (this.transferLastTick) {
            this.transferLastTick = false;
        } else {
            this.lastTransfer = 0L;
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.dead = true;
    }

    public long injectEnergyUnits(byte aSide, long aVoltage, long aAmperage) {
        if (this.inputEnergyFrom(aSide) && aAmperage > 0L && aVoltage > 0L && this.getStoredEU() < this.getEUCapacity() && this.getInputAmperage() > this.acceptedAmperes) {
            if (aVoltage > this.getInputVoltage()) {
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_72876_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 1.0f, true);
                return 0L;
            }
            if (this.increaseStoredEnergyUnits(aVoltage * (aAmperage = Math.min(aAmperage, Math.min(this.getInputAmperage() - this.acceptedAmperes, 1L + (this.getEUCapacity() - this.getStoredEU()) / aVoltage))), true)) {
                this.lastTransfer = aVoltage * aAmperage;
                this.transferLastTick = true;
                this.acceptedAmperes += aAmperage;
                return aAmperage;
            }
            return 0L;
        }
        return 0L;
    }

    public boolean inputEnergyFrom(byte arg0) {
        return true;
    }

    public boolean outputsEnergyTo(byte arg0) {
        return false;
    }

    public byte getColorization() {
        return 0;
    }

    public byte setColorization(byte arg0) {
        return arg0;
    }

    public boolean getAir(int x, int y, int z) {
        return GT_Utility.isBlockAir((World)this.field_145850_b, (int)x, (int)y, (int)z);
    }

    public final boolean getAirOffset(int aX, int aY, int aZ) {
        return this.getAir(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    public final boolean getAirAtSide(byte aSide) {
        return this.getAirAtSideAndDistance(aSide, 1);
    }

    public final boolean getAirAtSideAndDistance(byte aSide, int aDistance) {
        return this.getAir(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    public final BiomeGenBase getBiome(int aX, int aZ) {
        return this.field_145850_b.func_72807_a(aX, aZ);
    }

    public final BiomeGenBase getBiome() {
        return this.getBiome(this.field_145851_c, this.field_145849_e);
    }

    public Block getBlock(int x, int y, int z) {
        return this.field_145850_b.func_147439_a(x, y, z);
    }

    public final Block getBlockOffset(int aX, int aY, int aZ) {
        return this.getBlock(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    public final Block getBlockAtSide(byte aSide) {
        return this.getBlockAtSideAndDistance(aSide, 1);
    }

    public final Block getBlockAtSideAndDistance(byte aSide, int aDistance) {
        return this.getBlock(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    public IGregTechTileEntity getIGregTechTileEntity(int arg0, int arg1, int arg2) {
        TileEntity te = this.field_145850_b.func_147438_o(arg0, arg1, arg2);
        if (!(te instanceof IGregTechTileEntity)) {
            return null;
        }
        return (IGregTechTileEntity)te;
    }

    public IGregTechTileEntity getIGregTechTileEntityAtSide(byte arg0) {
        return this.getIGregTechTileEntityAtSideAndDistance(arg0, 1);
    }

    public IGregTechTileEntity getIGregTechTileEntityAtSideAndDistance(byte aSide, int aDistance) {
        return this.getIGregTechTileEntity(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    public IGregTechTileEntity getIGregTechTileEntityOffset(int x, int y, int z) {
        return this.getIGregTechTileEntity(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
    }

    public IInventory getIInventory(int arg0, int arg1, int arg2) {
        TileEntity te = this.field_145850_b.func_147438_o(arg0, arg1, arg2);
        if (!(te instanceof IInventory)) {
            return null;
        }
        return (IInventory)te;
    }

    public IInventory getIInventoryAtSide(byte arg0) {
        return this.getIInventoryAtSideAndDistance(arg0, 1);
    }

    public IInventory getIInventoryAtSideAndDistance(byte aSide, int aDistance) {
        return this.getIInventory(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    public IInventory getIInventoryOffset(int x, int y, int z) {
        return this.getIInventory(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
    }

    public IFluidHandler getITankContainer(int arg0, int arg1, int arg2) {
        TileEntity te = this.field_145850_b.func_147438_o(arg0, arg1, arg2);
        if (!(te instanceof IFluidHandler)) {
            return null;
        }
        return (IFluidHandler)te;
    }

    public IFluidHandler getITankContainerAtSide(byte arg0) {
        return this.getITankContainerAtSideAndDistance(arg0, 1);
    }

    public IFluidHandler getITankContainerAtSideAndDistance(byte aSide, int aDistance) {
        return this.getITankContainer(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    public IFluidHandler getITankContainerOffset(int x, int y, int z) {
        return this.getITankContainer(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
    }

    public byte getLightLevel(int aX, int aY, int aZ) {
        return (byte)(this.field_145850_b.func_72801_o(aX, aY, aZ) * 15.0f);
    }

    public byte getLightLevelAtSide(byte arg0) {
        return this.getLightLevelAtSideAndDistance(arg0, 1);
    }

    public byte getLightLevelAtSideAndDistance(byte aSide, int aDistance) {
        return this.getLightLevel(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    public byte getLightLevelOffset(int x, int y, int z) {
        return this.getLightLevel(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
    }

    public byte getMetaID(int x, int y, int z) {
        return (byte)this.field_145850_b.func_72805_g(x, y, z);
    }

    public byte getMetaIDAtSide(byte arg0) {
        return this.getMetaIDAtSideAndDistance(arg0, 1);
    }

    public byte getMetaIDAtSideAndDistance(byte aSide, int aDistance) {
        return this.getMetaID(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    public byte getMetaIDOffset(int x, int y, int z) {
        return this.getMetaID(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
    }

    public final int getOffsetX(byte aSide, int aMultiplier) {
        return this.field_145851_c + ForgeDirection.getOrientation((int)aSide).offsetX * aMultiplier;
    }

    public final short getOffsetY(byte aSide, int aMultiplier) {
        return (short)(this.field_145848_d + ForgeDirection.getOrientation((int)aSide).offsetY * aMultiplier);
    }

    public final int getOffsetZ(byte aSide, int aMultiplier) {
        return this.field_145849_e + ForgeDirection.getOrientation((int)aSide).offsetZ * aMultiplier;
    }

    public boolean getOpacity(int x, int y, int z) {
        return GT_Utility.isOpaqueBlock((World)this.field_145850_b, (int)x, (int)y, (int)z);
    }

    public boolean getOpacityAtSide(byte arg0) {
        return this.getOpacityAtSideAndDistance(arg0, 1);
    }

    public boolean getOpacityAtSideAndDistance(byte aSide, int aDistance) {
        return this.getOpacity(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    public boolean getOpacityOffset(int x, int y, int z) {
        return this.getOpacity(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
    }

    public int getRandomNumber(int max) {
        return this.field_145850_b.field_73012_v.nextInt(max);
    }

    public boolean getSky(int x, int y, int z) {
        return this.field_145850_b.func_72937_j(x, y, z);
    }

    public boolean getSkyAtSide(byte arg0) {
        return this.getSkyAtSideAndDistance(arg0, 1);
    }

    public boolean getSkyAtSideAndDistance(byte aSide, int aDistance) {
        return this.getSky(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    public boolean getSkyOffset(int x, int y, int z) {
        return this.getSky(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
    }

    public TileEntity getTileEntity(int x, int y, int z) {
        return this.field_145850_b.func_147438_o(x, y, z);
    }

    public TileEntity getTileEntityAtSide(byte arg0) {
        return this.getTileEntityAtSideAndDistance(arg0, 1);
    }

    public TileEntity getTileEntityAtSideAndDistance(byte aSide, int aDistance) {
        return this.getTileEntity(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    public TileEntity getTileEntityOffset(int x, int y, int z) {
        return this.getTileEntity(x, y, z);
    }

    public long getTimer() {
        return 0L;
    }

    public World getWorld() {
        return this.field_145850_b;
    }

    public int getXCoord() {
        return this.field_145851_c;
    }

    public short getYCoord() {
        return (short)this.field_145848_d;
    }

    public int getZCoord() {
        return this.field_145849_e;
    }

    public boolean isClientSide() {
        return this.field_145850_b.field_72995_K;
    }

    public boolean isDead() {
        return this.isInvalidTileEntity() || this.dead;
    }

    public boolean isInvalidTileEntity() {
        return this.func_145837_r();
    }

    public boolean isServerSide() {
        return !this.isClientSide();
    }

    public boolean openGUI(EntityPlayer player) {
        throw new UnsupportedOperationException("alec");
    }

    public boolean openGUI(EntityPlayer arg0, int arg1) {
        throw new UnsupportedOperationException("alec");
    }

    public void sendBlockEvent(byte arg0, byte arg1) {
        throw new UnsupportedOperationException("alec");
    }

    public void setLightValue(byte arg0) {
        throw new UnsupportedOperationException("alec");
    }

    public boolean decreaseStoredEnergyUnits(long arg0, boolean arg1) {
        return false;
    }

    public boolean drainEnergyUnits(byte arg0, long arg1, long arg2) {
        return false;
    }

    public long getAverageElectricInput() {
        return this.lastTransfer;
    }

    public long getAverageElectricOutput() {
        return 0L;
    }

    public long getEUCapacity() {
        TileEntityEnergyBridge bridge = this.getFirstBridge();
        if (bridge == null) {
            return 0L;
        }
        return (long)bridge.getEnergyStoredMax() / (long)this.getPowerSystem().getScaleAmmount();
    }

    public long getInputAmperage() {
        return 1L;
    }

    public long getInputVoltage() {
        return this.getPowerSystem().getVoltageValues()[this.getVoltageIndex()];
    }

    public long getOutputAmperage() {
        return 0L;
    }

    public long getOutputVoltage() {
        return 0L;
    }

    public long getSteamCapacity() {
        return 0L;
    }

    public long getStoredEU() {
        TileEntityEnergyBridge bridge = this.getFirstBridge();
        if (bridge == null) {
            return 0L;
        }
        return (long)bridge.getEnergyStored() / (long)this.getPowerSystem().getScaleAmmount();
    }

    public long getStoredSteam() {
        return 0L;
    }

    public long getUniversalEnergyCapacity() {
        return this.getEUCapacity();
    }

    public long getUniversalEnergyStored() {
        return this.getStoredEU();
    }

    public boolean increaseStoredEnergyUnits(long energy, boolean ignoreTooMuchEnergy) {
        TileEntityEnergyBridge bridge = this.getFirstBridge();
        if (bridge == null) {
            return ignoreTooMuchEnergy;
        }
        if (!ignoreTooMuchEnergy && this.storeEnergy(energy * (long)this.getPowerSystem().getScaleAmmount(), true) > 0.0) {
            return false;
        }
        this.storeEnergy(energy * (long)this.getPowerSystem().getScaleAmmount(), !ignoreTooMuchEnergy);
        return true;
    }

    public boolean increaseStoredSteam(long arg0, boolean arg1) {
        return false;
    }

    public boolean isUniversalEnergyStored(long arg0) {
        return this.getStoredEU() > arg0;
    }
}

