/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.pccompat.tiles;

import api.hbm.energymk2.IEnergyConnectorMK2;
import api.hbm.energymk2.IEnergyReceiverMK2;
import covers1624.powerconverters.tile.main.TileEntityEnergyConsumer;
import net.anvilcraft.pccompat.mods.HBMProxy;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityHBMConsumer
extends TileEntityEnergyConsumer<IEnergyConnectorMK2>
implements IEnergyReceiverMK2 {
    private boolean isLoaded = true;
    private boolean recursionBrake = false;
    private boolean transferLastTick = false;
    private double lastTransfer = 0.0;

    public TileEntityHBMConsumer() {
        super(HBMProxy.powerSystem, 0, IEnergyConnectorMK2.class);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
            }
        }
        if (this.transferLastTick) {
            this.transferLastTick = false;
        } else {
            this.lastTransfer = 0.0;
        }
    }

    public double getInputRate() {
        return this.lastTransfer;
    }

    public long getPower() {
        return 0L;
    }

    public long getMaxPower() {
        return (long)(this.getTotalEnergyDemand() / (double)this.getPowerSystem().getScaleAmmount());
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void onChunkUnload() {
        this.isLoaded = false;
        super.onChunkUnload();
    }

    public long transferPower(long power) {
        if (this.recursionBrake) {
            return power;
        }
        this.recursionBrake = true;
        long toInsert = power * (long)this.getPowerSystem().getScaleAmmount();
        double leftover = this.storeEnergy(toInsert, false);
        long ret = MathHelper.func_76124_d((double)(leftover / (double)this.getPowerSystem().getScaleAmmount()));
        this.lastTransfer = power - ret;
        this.recursionBrake = false;
        this.transferLastTick = true;
        return ret;
    }

    public void setPower(long power) {
    }
}

