/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.pccompat.tiles;

import api.hbm.energymk2.IEnergyConnectorMK2;
import api.hbm.energymk2.IEnergyProviderMK2;
import covers1624.powerconverters.tile.main.TileEntityEnergyBridge;
import covers1624.powerconverters.tile.main.TileEntityEnergyProducer;
import net.anvilcraft.pccompat.Utils;
import net.anvilcraft.pccompat.mods.HBMProxy;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityHBMProducer
extends TileEntityEnergyProducer<IEnergyConnectorMK2>
implements IEnergyProviderMK2 {
    private boolean isLoaded = true;
    private boolean recursionBrake = false;
    private long subBuffer = 0L;

    public TileEntityHBMProducer() {
        super(HBMProxy.powerSystem, 0, IEnergyConnectorMK2.class);
    }

    public double produceEnergy(double energy) {
        long toProduce;
        if (this.recursionBrake) {
            return energy;
        }
        this.recursionBrake = true;
        this.subBuffer = toProduce = MathHelper.func_76124_d((double)(energy / (double)this.getPowerSystem().getScaleAmmount()));
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.tryProvide(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
        }
        this.recursionBrake = false;
        long tmp = this.subBuffer;
        this.subBuffer = 0L;
        return tmp * (long)this.getPowerSystem().getScaleAmmount();
    }

    public void setPower(long power) {
        TileEntityEnergyBridge bridge = this.getFirstBridge();
        if (this.subBuffer != 0L) {
            this.subBuffer = power;
        } else if (bridge != null) {
            double energy = power * (long)this.getPowerSystem().getScaleAmmount();
            double currentEnergy = bridge.getEnergyStored();
            double diff = energy - currentEnergy;
            bridge.storeEnergy(diff, false);
            ForgeDirection side = Utils.getSide((TileEntity)bridge, (TileEntity)this);
            Utils.getOutputRates(bridge).put(side, -diff / (double)this.getPowerSystem().getScaleAmmount());
        }
    }

    public long getPower() {
        TileEntityEnergyBridge bridge = this.getFirstBridge();
        if (this.subBuffer != 0L) {
            return this.subBuffer;
        }
        if (bridge == null) {
            return 0L;
        }
        return (long)(bridge.getEnergyStored() / (double)this.getPowerSystem().getScaleAmmount());
    }

    public long getMaxPower() {
        return this.getPower();
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void onChunkUnload() {
        this.isLoaded = false;
        super.onChunkUnload();
    }
}

