/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.pccompat.tiles;

import com.cout970.magneticraft.api.electricity.ElectricUtils;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricTile;
import com.cout970.magneticraft.api.electricity.prefab.ElectricConductor;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.VecInt;
import covers1624.powerconverters.tile.main.TileEntityEnergyProducer;
import net.anvilcraft.pccompat.mods.MagneticraftProxy;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMagneticraftProducer
extends TileEntityEnergyProducer<IElectricTile>
implements IElectricTile {
    private IElectricConductor cond = new ElectricConductor((TileEntity)this);

    public TileEntityMagneticraftProducer() {
        super(MagneticraftProxy.powerSystem, 0, IElectricTile.class);
    }

    public IElectricConductor[] getConds(VecInt arg0, int arg1) {
        return new IElectricConductor[]{this.cond};
    }

    public void onNeighboorChanged() {
        super.onNeighboorChanged();
        this.cond.disconnect();
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.cond.recache();
        this.cond.iterate();
    }

    public double produceEnergy(double energy) {
        if (this.cond.getVoltage() >= 100.0 || energy <= 0.0) {
            return energy;
        }
        double joules = energy / (double)this.getPowerSystem().getScaleAmmount();
        double alec = Math.min((100.0 - this.cond.getVoltage()) * 80.0, Math.min(joules, 400.0));
        this.cond.applyPower(alec);
        return energy - alec * (double)this.getPowerSystem().getScaleAmmount();
    }

    public boolean isSideConnected(int side_) {
        MgDirection side = MgDirection.getDirection((int)side_);
        IElectricConductor[] conds = ElectricUtils.getElectricCond((TileEntity)new VecInt((TileEntity)this).add(side).getTileEntity((IBlockAccess)this.field_145850_b), (VecInt)VecInt.NULL_VECTOR, (int)0);
        return conds != null && conds.length > 0;
    }

    public boolean isSideConnectedClient(int side) {
        return this.isSideConnected(side);
    }

    public boolean isConnected() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.isSideConnected(dir.ordinal())) continue;
            return true;
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.cond.load(nbt);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.cond.save(nbt);
    }
}

