/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.pccompat.tiles;

import covers1624.powerconverters.tile.main.TileEntityEnergyConsumer;
import mods.railcraft.api.electricity.IElectricGrid;
import net.anvilcraft.pccompat.mods.RailcraftProxy;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileEntityRailcraftConsumer
extends TileEntityEnergyConsumer<IElectricGrid>
implements IElectricGrid {
    private IElectricGrid.ChargeHandler chargeHandler = new IElectricGrid.ChargeHandler((IElectricGrid)this, IElectricGrid.ChargeHandler.ConnectType.BLOCK);
    private double lastTransfer = 0.0;

    public TileEntityRailcraftConsumer() {
        super(RailcraftProxy.powerSystem, 0, IElectricGrid.class);
    }

    public IElectricGrid.ChargeHandler getChargeHandler() {
        return this.chargeHandler;
    }

    public TileEntity getTile() {
        return this;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.chargeHandler.readFromNBT(tagCompound);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.chargeHandler.tick();
            double demand = this.getTotalEnergyDemand() / (double)this.getPowerSystem().getScaleAmmount();
            double consumed = 0.0;
            if (demand > 0.0) {
                consumed = this.chargeHandler.removeCharge(demand);
                this.storeEnergy(consumed * (double)this.getPowerSystem().getScaleAmmount(), false);
            }
            this.lastTransfer = consumed;
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.chargeHandler.writeToNBT(tagCompound);
    }

    public double getInputRate() {
        return this.lastTransfer;
    }
}

