/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.pccompat.tiles;

import covers1624.powerconverters.tile.main.TileEntityEnergyProducer;
import mods.railcraft.api.electricity.IElectricGrid;
import net.anvilcraft.pccompat.mods.RailcraftProxy;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileEntityRailcraftProducer
extends TileEntityEnergyProducer<IElectricGrid>
implements IElectricGrid {
    private IElectricGrid.ChargeHandler chargeHandler = new IElectricGrid.ChargeHandler((IElectricGrid)this, IElectricGrid.ChargeHandler.ConnectType.BLOCK);

    public TileEntityRailcraftProducer() {
        super(RailcraftProxy.powerSystem, 0, IElectricGrid.class);
    }

    public double produceEnergy(double energy) {
        double charge = energy / (double)this.getPowerSystem().getScaleAmmount();
        double toProduce = Math.min(charge, this.chargeHandler.getCapacity() - this.chargeHandler.getCharge());
        this.chargeHandler.addCharge(toProduce);
        return energy - toProduce * (double)this.getPowerSystem().getScaleAmmount();
    }

    public IElectricGrid.ChargeHandler getChargeHandler() {
        return this.chargeHandler;
    }

    public TileEntity getTile() {
        return this;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.chargeHandler.readFromNBT(tagCompound);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.chargeHandler.tick();
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.chargeHandler.writeToNBT(tagCompound);
    }
}

