/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.pccompat.tiles;

import covers1624.powerconverters.tile.main.TileEntityEnergyProducer;
import net.anvilcraft.pccompat.mods.UltraTechProxy;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import ultratech.api.power.NetworkManagerRegistry;
import ultratech.api.power.PowerInterface;
import ultratech.api.power.StorageInterface;
import ultratech.api.power.interfaces.ICable;
import ultratech.api.power.interfaces.IPowerConductor;
import ultratech.api.power.prefab.CableInterfaceBlock;

public class TileEntityUltraTechProducer
extends TileEntityEnergyProducer<IPowerConductor>
implements IPowerConductor {
    private StorageInterface interf = new StorageInterface((TileEntity)this, (ICable)new CableInterfaceBlock((IPowerConductor)this), 10000.0, 1);

    public TileEntityUltraTechProducer() {
        super(UltraTechProxy.powerSystem, 0, IPowerConductor.class);
        this.interf.configIO = StorageInterface.PowerIO.Output;
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.interf.MachineUpdate();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.interf.readFromNBT(nbt);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.interf.writeToNBT(nbt);
    }

    public boolean isSideConnected(int side_) {
        ForgeDirection side = ForgeDirection.getOrientation((int)side_);
        TileEntity adjTE = this.field_145850_b.func_147438_o(this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ);
        if (adjTE instanceof IPowerConductor) {
            return true;
        }
        if (adjTE == null) {
            return false;
        }
        for (ICable cable : NetworkManagerRegistry.getConnections((TileEntity)adjTE)) {
            if (!cable.shouldConnectWithThis(this.interf.getCable(), side.getOpposite())) continue;
            return true;
        }
        return false;
    }

    public boolean isSideConnectedClient(int side) {
        return this.isSideConnected(side);
    }

    public boolean isConnected() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.isSideConnected(dir.ordinal())) continue;
            return true;
        }
        return false;
    }

    public PowerInterface getPower() {
        return this.interf;
    }

    public double produceEnergy(double energy) {
        double toProduce = Math.min(energy / (double)this.getPowerSystem().getScaleAmmount(), this.interf.getCapacity() - this.interf.getCharge());
        this.interf.addCharge(toProduce);
        return energy - toProduce * (double)this.getPowerSystem().getScaleAmmount();
    }
}

