/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.pccompat.tiles;

import covers1624.powerconverters.tile.main.TileEntityEnergyConsumer;
import net.anvilcraft.pccompat.mods.UniversalElectricityProxy;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;
import universalelectricity.core.UniversalElectricity;
import universalelectricity.core.block.IConductor;
import universalelectricity.core.block.IConnector;
import universalelectricity.core.block.IVoltage;
import universalelectricity.core.electricity.ElectricityNetworkHelper;
import universalelectricity.core.electricity.ElectricityPack;

public class TileEntityUniversalElectricityConsumer
extends TileEntityEnergyConsumer<IConductor>
implements IConnector,
IVoltage {
    private double wattsLastTick;

    public TileEntityUniversalElectricityConsumer(int voltageNameIndex) {
        super(UniversalElectricityProxy.powerSystem, voltageNameIndex, IConductor.class);
    }

    public TileEntityUniversalElectricityConsumer() {
        this(0);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        double desiredWatts = this.getTotalEnergyDemand() / (double)this.getPowerSystem().getScaleAmmount();
        ElectricityPack powerRequested = new ElectricityPack(desiredWatts / this.getVoltage(), this.getVoltage());
        ElectricityPack powerPack = ElectricityNetworkHelper.consumeFromMultipleSides((TileEntity)this, (ElectricityPack)powerRequested);
        if (UniversalElectricity.isVoltageSensitive && powerPack.voltage > this.getVoltage()) {
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_72876_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 1.0f, true);
        }
        double watts = powerPack.getWatts();
        this.storeEnergy(MathHelper.func_76128_c((double)(watts * (double)this.getPowerSystem().getScaleAmmount())), false);
        this.wattsLastTick = watts;
    }

    public boolean canConnect(ForgeDirection from) {
        return true;
    }

    public double getInputRate() {
        return this.wattsLastTick;
    }

    public double getVoltage() {
        return this.getPowerSystem().getVoltageValues()[this.getVoltageIndex()];
    }
}

