/*
 * Decompiled with CFR 0.152.
 */
package net.anvilcraft.pccompat.tiles;

import covers1624.powerconverters.tile.main.TileEntityEnergyProducer;
import net.anvilcraft.pccompat.mods.UniversalElectricityProxy;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;
import universalelectricity.core.block.IConductor;
import universalelectricity.core.block.IConnector;
import universalelectricity.core.block.IVoltage;
import universalelectricity.core.electricity.ElectricityNetworkHelper;
import universalelectricity.core.electricity.ElectricityPack;

public class TileEntityUniversalElectricityProducer
extends TileEntityEnergyProducer<IConductor>
implements IConnector,
IVoltage {
    public TileEntityUniversalElectricityProducer(int voltageNameIndex) {
        super(UniversalElectricityProxy.powerSystem, voltageNameIndex, IConductor.class);
    }

    public TileEntityUniversalElectricityProducer() {
        this(0);
    }

    public double getVoltage() {
        return this.getPowerSystem().getVoltageValues()[this.getVoltageIndex()];
    }

    public boolean canConnect(ForgeDirection from) {
        return true;
    }

    public double produceEnergy(double energy) {
        double watts = energy / (double)this.getPowerSystem().getScaleAmmount();
        ElectricityPack powerRemaining = ElectricityNetworkHelper.produceFromMultipleSides((TileEntity)this, (ElectricityPack)new ElectricityPack(watts / this.getVoltage(), this.getVoltage()));
        return MathHelper.func_76128_c((double)(powerRemaining.getWatts() * (double)this.getPowerSystem().getScaleAmmount()));
    }
}

