/*
 * Decompiled with CFR 0.152.
 */
package io.github.skydynamic.quickbakcupmulti;

import com.mojang.brigadier.CommandDispatcher;
import io.github.skydynamic.quickbakcupmulti.ModEnvType;
import io.github.skydynamic.quickbakcupmulti.ModVersion;
import io.github.skydynamic.quickbakcupmulti.schedule.IModSchedule;
import io.github.skydynamic.quickbakcupmulti.utils.permission.PermissionManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;

public class ModContainer {
    private ModVersion modVersion;
    private ModEnvType envType;
    private String originalStoragePath;
    private String levelId = "";
    private CommandDispatcher<CommandSourceStack> dispatcher;
    private Path configPath;
    private PermissionManager permissionManager;
    private Path currentSavePath;
    private boolean isRestoringBackup;
    private String currentSelectionBackup;
    private List<IModSchedule> schedules = new ArrayList<IModSchedule>();

    public ModContainer(CommandDispatcher<CommandSourceStack> dispatcher) {
        this.dispatcher = dispatcher;
    }

    public ModContainer() {
    }

    public Optional<IModSchedule> getSchedule(String name) {
        return this.schedules.stream().filter(it -> it.getName().equals(name)).findFirst();
    }

    public void setModVersion(ModVersion modVersion) {
        this.modVersion = modVersion;
    }

    public void setEnvType(ModEnvType envType) {
        this.envType = envType;
    }

    public void setOriginalStoragePath(String originalStoragePath) {
        this.originalStoragePath = originalStoragePath;
    }

    public void setLevelId(String levelId) {
        this.levelId = levelId;
    }

    public void setDispatcher(CommandDispatcher<CommandSourceStack> dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void setConfigPath(Path configPath) {
        this.configPath = configPath;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setCurrentSavePath(Path currentSavePath) {
        this.currentSavePath = currentSavePath;
    }

    public void setRestoringBackup(boolean isRestoringBackup) {
        this.isRestoringBackup = isRestoringBackup;
    }

    public void setCurrentSelectionBackup(String currentSelectionBackup) {
        this.currentSelectionBackup = currentSelectionBackup;
    }

    public void setSchedules(List<IModSchedule> schedules) {
        this.schedules = schedules;
    }

    public ModVersion getModVersion() {
        return this.modVersion;
    }

    public ModEnvType getEnvType() {
        return this.envType;
    }

    public String getOriginalStoragePath() {
        return this.originalStoragePath;
    }

    public String getLevelId() {
        return this.levelId;
    }

    public CommandDispatcher<CommandSourceStack> getDispatcher() {
        return this.dispatcher;
    }

    public Path getConfigPath() {
        return this.configPath;
    }

    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    public Path getCurrentSavePath() {
        return this.currentSavePath;
    }

    public boolean isRestoringBackup() {
        return this.isRestoringBackup;
    }

    public String getCurrentSelectionBackup() {
        return this.currentSelectionBackup;
    }

    public List<IModSchedule> getSchedules() {
        return this.schedules;
    }
}

