/*
 * Decompiled with CFR 0.152.
 */
package io.github.skydynamic.quickbakcupmulti;

import io.github.skydynamic.increment.storage.lib.database.Database;
import io.github.skydynamic.increment.storage.lib.manager.IConfig;
import io.github.skydynamic.increment.storage.lib.manager.IDatabaseManager;
import io.github.skydynamic.increment.storage.lib.utils.StorageManager;
import io.github.skydynamic.quickbakcupmulti.ModContainer;
import io.github.skydynamic.quickbakcupmulti.ModEnvType;
import io.github.skydynamic.quickbakcupmulti.ServerManager;
import io.github.skydynamic.quickbakcupmulti.command.ModCommand;
import io.github.skydynamic.quickbakcupmulti.config.ModConfig;
import io.github.skydynamic.quickbakcupmulti.database.DatabaseManager;
import io.github.skydynamic.quickbakcupmulti.schedule.quartz.DisableQuartzInfoLogger;
import io.github.skydynamic.quickbakcupmulti.translate.Translate;
import io.github.skydynamic.quickbakcupmulti.utils.UpdateChecker;
import io.github.skydynamic.quickbakcupmulti.utils.permission.PermissionManager;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QuickbakcupmultiReforged {
    public static final String MOD_ID = "quickbakcupmulti_reforged";
    public static final String MOD_NAME = "QuickBackupMulti";
    public static final Logger logger = LoggerFactory.getLogger((String)"QuickBackupMulti");
    private static Database database;
    private static StorageManager manager;
    private static ServerManager serverManager;
    private static ModContainer modContainer;
    private static ModConfig modConfig;

    public static void init(ModContainer container) {
        modContainer = container;
        modConfig = new ModConfig(modContainer.getConfigPath().resolve("QuickBackupMulti.json"));
        modConfig.load();
        modConfig.save();
        modContainer.setPermissionManager(new PermissionManager());
        if (modConfig.isCheckUpdate()) {
            new UpdateChecker().start();
        }
        Translate.handleResourceReload(modConfig.getLang());
        File storagePath = new File(modConfig.getStoragePath());
        if (!storagePath.exists()) {
            storagePath.mkdirs();
        }
        DisableQuartzInfoLogger.disable();
    }

    public static void registerCommand() {
        if (modContainer.getDispatcher() == null) {
            return;
        }
        ModCommand.register(modContainer.getDispatcher());
    }

    public static String formatTimestamp(long timestamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(timestamp);
    }

    public static void setNewDataBase(String collectionName) {
        QuickbakcupmultiReforged.getModContainer().setOriginalStoragePath(QuickbakcupmultiReforged.getModConfig().getStoragePath());
        Object appendFolder = QuickbakcupmultiReforged.getModContainer().getEnvType() == ModEnvType.CLIENT ? "/" + collectionName : "";
        DatabaseManager databaseManager = new DatabaseManager(MOD_NAME, QuickbakcupmultiReforged.getModConfig().getStoragePath(), UUID.nameUUIDFromBytes(collectionName.getBytes()));
        ModConfig modTempConfig = QuickbakcupmultiReforged.getModConfig().copy();
        modTempConfig.setStoragePath(QuickbakcupmultiReforged.getModConfig().getStoragePath() + (String)appendFolder);
        QuickbakcupmultiReforged.setDatabase(new Database((IDatabaseManager)databaseManager));
        QuickbakcupmultiReforged.setManager(new StorageManager(QuickbakcupmultiReforged.getDatabase(), (IConfig)modTempConfig));
    }

    public static Database getDatabase() {
        return database;
    }

    public static void setDatabase(Database database) {
        QuickbakcupmultiReforged.database = database;
    }

    public static StorageManager getManager() {
        return manager;
    }

    public static void setManager(StorageManager manager) {
        QuickbakcupmultiReforged.manager = manager;
    }

    public static ServerManager getServerManager() {
        return serverManager;
    }

    public static void setServerManager(ServerManager serverManager) {
        QuickbakcupmultiReforged.serverManager = serverManager;
    }

    public static ModContainer getModContainer() {
        return modContainer;
    }

    public static void setModContainer(ModContainer modContainer) {
        QuickbakcupmultiReforged.modContainer = modContainer;
    }

    public static ModConfig getModConfig() {
        return modConfig;
    }

    public static void setModConfig(ModConfig modConfig) {
        QuickbakcupmultiReforged.modConfig = modConfig;
    }
}

