/*
 * Decompiled with CFR 0.152.
 */
package io.github.skydynamic.quickbakcupmulti.client.screen;

import io.github.skydynamic.quickbakcupmulti.translate.Translate;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class RestoreScreen
extends Screen {
    private final Button cancelButton;
    private String state = Translate.tr("quickbackupmulti.screen.restore_screen.waiting_for_server", new Object[0]);
    private float progress = 0.0f;

    public RestoreScreen(Button.OnPress onCancelButtonPress) {
        super(Component.nullToEmpty((String)Translate.tr("quickbackupmulti.screen.restore_screen.title", new Object[0])));
        this.cancelButton = Button.builder((Component)Component.nullToEmpty((String)Translate.tr("quickbackupmulti.screen.restore_screen.cancel_button", new Object[0])), (Button.OnPress)onCancelButtonPress).build();
    }

    protected void init() {
        this.cancelButton.setPosition(this.width / 2 - this.cancelButton.getWidth() / 2, this.height / 2 + 40);
        this.addRenderableWidget((GuiEventListener)this.cancelButton);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.render(guiGraphics, mouseX, mouseY, delta);
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        guiGraphics.drawCenteredString(this.font, Component.nullToEmpty((String)this.state), centerX, centerY - 20, 0xFFFFFF);
        this.drawProgressBar(guiGraphics, centerX - 70, centerY - 5, centerX + 70, centerY + 5);
        guiGraphics.drawCenteredString(this.font, Component.nullToEmpty((String)Translate.tr("quickbackupmulti.screen.restore_screen.progress", this.getPercentString())), centerX, centerY + 10, 0xFFFFFF);
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    protected boolean shouldNarrateNavigation() {
        return false;
    }

    private String getPercentString() {
        return String.format("%.2f", Float.valueOf(this.progress * 100.0f));
    }

    private void drawProgressBar(GuiGraphics guiGraphics, int x0, int y0, int x1, int y1) {
        int barX0 = x0 + 2;
        int barY0 = y0 + 2;
        int barX1 = x0 + (int)((float)(x1 - x0) * this.progress);
        int barY1 = y1 - 2;
        int progressBarColor = RestoreScreen.colorFromRatio(this.progress, true);
        guiGraphics.fill(x0, y0, x1, y1, -1);
        guiGraphics.fill(barX0, barY0, barX1, barY1, progressBarColor);
    }

    private static int colorFromRatio(double ratio, boolean oneIsGreen) {
        double p = ratio;
        if (!oneIsGreen) {
            p = 1.0 - p;
        }
        int r = (int)(255.0 * Math.max(0.0, Math.min(2.0 - 2.0 * p, 1.0)));
        int g = (int)(255.0 * Math.max(0.0, Math.min(2.0 * p, 1.0)));
        return -16777216 + (r << 16) + (g << 8);
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderPanorama(guiGraphics, f);
        this.renderBlurredBackground(guiGraphics);
        this.renderMenuBackground(guiGraphics);
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }
}

