/*
 * Decompiled with CFR 0.152.
 */
package io.github.skydynamic.quickbakcupmulti.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.skydynamic.increment.storage.lib.database.StorageInfo;
import io.github.skydynamic.quickbakcupmulti.DatabaseCache;
import io.github.skydynamic.quickbakcupmulti.QuickbakcupmultiReforged;
import io.github.skydynamic.quickbakcupmulti.command.ModCommand;
import io.github.skydynamic.quickbakcupmulti.translate.Translate;
import io.github.skydynamic.quickbakcupmulti.utils.BackupManager;
import io.github.skydynamic.quickbakcupmulti.utils.permission.PermissionManager;
import io.github.skydynamic.quickbakcupmulti.utils.permission.PermissionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class DeleteCommand {
    public static final LiteralArgumentBuilder<CommandSourceStack> cmd = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"delete").requires(it -> PermissionManager.hasPermission(it, 2, PermissionType.HELPER))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
        for (StorageInfo info : BackupManager.getBackupsList()) {
            if (!info.getName().contains(builder.getRemaining())) continue;
            builder.suggest(info.getName());
        }
        return builder.buildFuture();
    }).executes(it -> DeleteCommand.deleteBackup((CommandSourceStack)it.getSource(), StringArgumentType.getString((CommandContext)it, (String)"name"))));

    private static int deleteBackup(CommandSourceStack commandSource, String name) {
        new ModCommand.CmdExecuteThread(() -> {
            if (BackupManager.deleteBackup(commandSource, name)) {
                commandSource.sendSystemMessage((Component)Component.literal((String)Translate.tr("quickbackupmulti.delete.success", name)));
                if (QuickbakcupmultiReforged.getModConfig().isCacheDatabase()) {
                    DatabaseCache.updateStorageInfoCaches();
                }
            } else {
                commandSource.sendSystemMessage((Component)Component.literal((String)Translate.tr("quickbackupmulti.delete.fail", name)));
            }
        });
        return 0;
    }
}

