/*
 * Decompiled with CFR 0.152.
 */
package io.github.skydynamic.quickbakcupmulti.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.skydynamic.quickbakcupmulti.DatabaseCache;
import io.github.skydynamic.quickbakcupmulti.QuickbakcupmultiReforged;
import io.github.skydynamic.quickbakcupmulti.schedule.ScheduleManager;
import io.github.skydynamic.quickbakcupmulti.utils.BackupManager;
import io.github.skydynamic.quickbakcupmulti.utils.permission.PermissionManager;
import io.github.skydynamic.quickbakcupmulti.utils.permission.PermissionType;
import java.text.SimpleDateFormat;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public class MakeCommand {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HHmmss");
    public static final LiteralArgumentBuilder<CommandSourceStack> cmd = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"make").requires(it -> PermissionManager.hasPermission(it, 4, PermissionType.HELPER))).executes(it -> MakeCommand.makeSaveBackup((CommandSourceStack)it.getSource(), dateFormat.format(System.currentTimeMillis()), ""))).then(((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(it -> MakeCommand.makeSaveBackup((CommandSourceStack)it.getSource(), StringArgumentType.getString((CommandContext)it, (String)"name"), ""))).then(Commands.argument((String)"desc", (ArgumentType)StringArgumentType.string()).executes(it -> MakeCommand.makeSaveBackup((CommandSourceStack)it.getSource(), StringArgumentType.getString((CommandContext)it, (String)"name"), StringArgumentType.getString((CommandContext)it, (String)"desc")))));

    private static int makeSaveBackup(CommandSourceStack commandSource, String name, String desc) {
        new Thread(new makeRunnable(commandSource, name, desc)).start();
        return 1;
    }

    static class makeRunnable
    implements Runnable {
        CommandSourceStack sourceStack;
        String name;
        String desc;

        makeRunnable(CommandSourceStack commandSource, String name, String desc) {
            this.sourceStack = commandSource;
            this.name = name;
            this.desc = desc;
        }

        @Override
        public void run() {
            long l = System.currentTimeMillis();
            QuickbakcupmultiReforged.logger.info("Make Backup thread started...");
            BackupManager.makeBackup(this.sourceStack, this.name, this.desc);
            if (QuickbakcupmultiReforged.getModConfig().isCacheDatabase()) {
                DatabaseCache.updateStorageInfoCaches();
            }
            if (QuickbakcupmultiReforged.getModConfig().getScheduleBackupConfig().isResetTimerOnBackup() && ScheduleManager.resetTimer("scheduleBackup")) {
                QuickbakcupmultiReforged.logger.info("Reset timer for scheduleBackup");
            }
            QuickbakcupmultiReforged.logger.info("Make Backup thread close => {}ms", (Object)(System.currentTimeMillis() - l));
        }
    }
}

