/*
 * Decompiled with CFR 0.152.
 */
package io.github.skydynamic.quickbakcupmulti.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.skydynamic.quickbakcupmulti.QuickbakcupmultiReforged;
import io.github.skydynamic.quickbakcupmulti.translate.Translate;
import io.github.skydynamic.quickbakcupmulti.utils.permission.PermissionManager;
import io.github.skydynamic.quickbakcupmulti.utils.permission.PermissionType;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;

public class PermissionCommand {
    public static final LiteralArgumentBuilder<CommandSourceStack> cmd = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"permission").requires(it -> PermissionManager.hasPermission(it, 4, PermissionType.ADMIN))).then(Commands.literal((String)"set").then(Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)2)).executes(it -> PermissionCommand.setPermission((CommandSourceStack)it.getSource(), GameProfileArgument.getGameProfiles((CommandContext)it, (String)"player"), IntegerArgumentType.getInteger((CommandContext)it, (String)"level"))))))).then(Commands.literal((String)"reload").executes(it -> PermissionCommand.reloadPermission((CommandSourceStack)it.getSource())));

    private static int setPermission(CommandSourceStack commandSource, Collection<GameProfile> players, int level) {
        players.forEach(player -> {
            QuickbakcupmultiReforged.getModContainer().getPermissionManager().setPermissionByPermissionLevelInt(level, player.getName());
            commandSource.sendSystemMessage((Component)Component.literal((String)"Set %s to %s".formatted(player.getName(), PermissionType.getByLevelInt(level).name())));
        });
        return 1;
    }

    private static int reloadPermission(CommandSourceStack commandSource) {
        QuickbakcupmultiReforged.getModContainer().getPermissionManager().reloadPermission();
        commandSource.sendSystemMessage((Component)Component.literal((String)Translate.tr("quickbackupmulti.permission.reload", new Object[0])));
        return 1;
    }
}

