/*
 * Decompiled with CFR 0.152.
 */
package io.github.skydynamic.quickbakcupmulti.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.skydynamic.increment.storage.lib.database.StorageInfo;
import io.github.skydynamic.quickbakcupmulti.QuickbakcupmultiReforged;
import io.github.skydynamic.quickbakcupmulti.command.ModCommand;
import io.github.skydynamic.quickbakcupmulti.restore.RestoreTimer;
import io.github.skydynamic.quickbakcupmulti.translate.Translate;
import io.github.skydynamic.quickbakcupmulti.utils.BackupManager;
import io.github.skydynamic.quickbakcupmulti.utils.permission.PermissionManager;
import io.github.skydynamic.quickbakcupmulti.utils.permission.PermissionType;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class RestoreCommand {
    public static final LiteralArgumentBuilder<CommandSourceStack> restoreCmd = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"restore").requires(it -> PermissionManager.hasPermission(it, 4, PermissionType.ADMIN))).then(Commands.argument((String)"target", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
        List<StorageInfo> backups = BackupManager.getSortedBackups();
        String remaining = builder.getRemaining();
        int index = 1;
        for (StorageInfo info : backups) {
            String idx;
            String name = info.getName();
            if (name.contains(remaining)) {
                builder.suggest(name);
            }
            if (!(idx = String.valueOf(index++)).startsWith(remaining)) continue;
            builder.suggest(idx);
        }
        return builder.buildFuture();
    }).executes(it -> RestoreCommand.restoreBackup((CommandSourceStack)it.getSource(), StringArgumentType.getString((CommandContext)it, (String)"target"))));
    public static final LiteralArgumentBuilder<CommandSourceStack> confirmCmd = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"confirm").requires(it -> PermissionManager.hasPermission(it, 4, PermissionType.ADMIN))).executes(it -> {
        try {
            RestoreCommand.executeRestore((CommandSourceStack)it.getSource());
        }
        catch (Exception e) {
            ModCommand.getLogger().error("Restore failed", (Throwable)e);
        }
        return 0;
    });
    public static final LiteralArgumentBuilder<CommandSourceStack> cancelCmd = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"cancel").requires(it -> PermissionManager.hasPermission(it, 4, PermissionType.ADMIN))).executes(it -> RestoreCommand.cancelRestore((CommandSourceStack)it.getSource()));
    private static final ConcurrentHashMap<String, ConcurrentHashMap<String, Object>> restoreDataMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int restoreBackup(CommandSourceStack commandSource, String target) {
        String name = RestoreCommand.resolveBackupName(target);
        if (name == null || !QuickbakcupmultiReforged.getDatabase().storageExists(name)) {
            commandSource.sendSystemMessage(Component.nullToEmpty((String)Translate.tr("quickbackupmulti.restore.fail", new Object[0])));
            return 0;
        }
        ConcurrentHashMap<String, Object> restoreMap = new ConcurrentHashMap<String, Object>();
        restoreMap.put("Slot", name);
        restoreMap.put("Timer", new Timer());
        restoreMap.put("Countdown", Executors.newSingleThreadScheduledExecutor());
        ConcurrentHashMap<String, ConcurrentHashMap<String, Object>> concurrentHashMap = restoreDataMap;
        synchronized (concurrentHashMap) {
            restoreDataMap.put("QBM", restoreMap);
            commandSource.sendSystemMessage(Component.nullToEmpty((String)Translate.tr("quickbackupmulti.restore.confirm_hint", new Object[0])));
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeRestore(CommandSourceStack commandSource) {
        ConcurrentHashMap<String, ConcurrentHashMap<String, Object>> concurrentHashMap = restoreDataMap;
        synchronized (concurrentHashMap) {
            if (restoreDataMap.containsKey("QBM")) {
                if (!QuickbakcupmultiReforged.getDatabase().storageExists(restoreDataMap.get("QBM").get("Slot").toString())) {
                    commandSource.sendSystemMessage(Component.nullToEmpty((String)Translate.tr("quickbackupmulti.restore.fail", new Object[0])));
                    restoreDataMap.clear();
                    return;
                }
                String executePlayerName = commandSource.getPlayer() != null ? commandSource.getPlayer().getGameProfile().getName() : "Console";
                commandSource.sendSystemMessage(Component.nullToEmpty((String)Translate.tr("quickbackupmulti.restore.abort_hint", new Object[0])));
                MinecraftServer server = commandSource.getServer();
                ArrayList<ServerPlayer> players = new ArrayList<ServerPlayer>(server.getPlayerList().getPlayers());
                for (ServerPlayer player : players) {
                    player.sendSystemMessage(Component.nullToEmpty((String)Translate.tr("quickbackupmulti.restore.countdown.intro", executePlayerName)));
                }
                String slot = (String)restoreDataMap.get("QBM").get("Slot");
                QuickbakcupmultiReforged.getModContainer().setCurrentSelectionBackup(slot);
                Timer timer = (Timer)restoreDataMap.get("QBM").get("Timer");
                ScheduledExecutorService countdown = (ScheduledExecutorService)restoreDataMap.get("QBM").get("Countdown");
                AtomicInteger countDown = new AtomicInteger(11);
                countdown.scheduleAtFixedRate(() -> {
                    int remaining = countDown.decrementAndGet();
                    if (remaining >= 1) {
                        MutableComponent content = Component.literal((String)Translate.tr("quickbackupmulti.restore.countdown.text", remaining, slot)).append((Component)Component.literal((String)Translate.tr("quickbackupmulti.restore.countdown.hover", new Object[0])).withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.RunCommand("/qb cancel"))));
                        for (ServerPlayer player : players) {
                            player.sendSystemMessage((Component)content, false);
                        }
                        ModCommand.getLogger().info(content.getString());
                    } else {
                        countdown.shutdown();
                    }
                }, 0L, 1L, TimeUnit.SECONDS);
                timer.schedule((TimerTask)new RestoreTimer(QuickbakcupmultiReforged.getModContainer().getEnvType(), players), 10000L);
            } else {
                commandSource.sendSystemMessage(Component.nullToEmpty((String)Translate.tr("quickbackupmulti.confirm_restore.nothing_to_confirm", new Object[0])));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int cancelRestore(CommandSourceStack commandSource) {
        if (restoreDataMap.containsKey("QBM")) {
            ConcurrentHashMap<String, ConcurrentHashMap<String, Object>> concurrentHashMap = restoreDataMap;
            synchronized (concurrentHashMap) {
                Timer timer = (Timer)restoreDataMap.get("QBM").get("Timer");
                ScheduledExecutorService countdown = (ScheduledExecutorService)restoreDataMap.get("QBM").get("Countdown");
                timer.cancel();
                countdown.shutdown();
                restoreDataMap.clear();
                QuickbakcupmultiReforged.getModContainer().setRestoringBackup(false);
                commandSource.sendSystemMessage(Component.nullToEmpty((String)Translate.tr("quickbackupmulti.restore.abort", new Object[0])));
            }
        } else {
            commandSource.sendSystemMessage(Component.nullToEmpty((String)Translate.tr("quickbackupmulti.confirm_restore.nothing_to_confirm", new Object[0])));
        }
        return 1;
    }

    private static String resolveBackupName(String target) {
        String trimmed = target.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        if (trimmed.chars().allMatch(Character::isDigit)) {
            try {
                int index = Integer.parseInt(trimmed);
                StorageInfo info = BackupManager.getBackupByIndex(index);
                if (info != null) {
                    return info.getName();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return trimmed;
    }

    public static ConcurrentHashMap<String, ConcurrentHashMap<String, Object>> getRestoreDataMap() {
        return restoreDataMap;
    }
}

