/*
 * Decompiled with CFR 0.152.
 */
package io.github.skydynamic.quickbakcupmulti.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.skydynamic.increment.storage.lib.database.StorageInfo;
import io.github.skydynamic.quickbakcupmulti.translate.Translate;
import io.github.skydynamic.quickbakcupmulti.utils.BackupManager;
import io.github.skydynamic.quickbakcupmulti.utils.ListBackupsUtils;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;

public class SearchCommand {
    public static final LiteralArgumentBuilder<CommandSourceStack> cmd = (LiteralArgumentBuilder)Commands.literal((String)"search").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(it -> SearchCommand.searchSaveBackups((CommandSourceStack)it.getSource(), StringArgumentType.getString((CommandContext)it, (String)"name"))));

    private static int searchSaveBackups(CommandSourceStack commandSource, String string) {
        List<String> backupsList = BackupManager.getBackupsList().stream().map(StorageInfo::getName).toList();
        List<String> result = backupsList.stream().filter(it -> StringUtils.containsIgnoreCase((CharSequence)it, (CharSequence)string)).toList();
        if (result.isEmpty()) {
            commandSource.sendSystemMessage(Component.nullToEmpty((String)Translate.tr("quickbackupmulti.search.fail", new Object[0])));
        } else {
            commandSource.sendSystemMessage((Component)ListBackupsUtils.search(result));
        }
        return 1;
    }
}

