/*
 * Decompiled with CFR 0.152.
 */
package io.github.skydynamic.quickbakcupmulti.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.skydynamic.increment.storage.lib.manager.IConfig;
import io.github.skydynamic.quickbakcupmulti.config.DatabaseConfig;
import io.github.skydynamic.quickbakcupmulti.config.PbsConfig;
import io.github.skydynamic.quickbakcupmulti.config.PruneScheduleConfig;
import io.github.skydynamic.quickbakcupmulti.config.ScheduleBackupConfig;
import io.github.skydynamic.quickbakcupmulti.config.ScheduleConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModConfig
implements IConfig {
    private static final Logger logger = LoggerFactory.getLogger((String)"Qbm-Config");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().serializeNulls().create();
    private ConfigStorage config = new ConfigStorage();
    private final Path path;

    public ModConfig(Path path) {
        this.path = path;
    }

    public boolean save() {
        if (!Files.exists(this.path, new LinkOption[0])) {
            try {
                Files.createFile(this.path, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.error("Save {} error: create file failed.", (Object)this.path, (Object)e);
                return false;
            }
        }
        try (BufferedWriter bfw = Files.newBufferedWriter(this.path, StandardCharsets.UTF_8, new OpenOption[0]);){
            gson.toJson((Object)this.getConfig(), (Appendable)bfw);
        }
        catch (IOException e) {
            logger.error("Save {} error: write file failed.", (Object)this.path, (Object)e);
            return false;
        }
        return true;
    }

    public boolean load() {
        if (this.path == null) {
            logger.error("Config Path is null");
            return false;
        }
        if (!Files.exists(this.path, new LinkOption[0])) {
            return this.save();
        }
        try (BufferedReader bfr = Files.newBufferedReader(this.path, StandardCharsets.UTF_8);){
            this.setConfig((ConfigStorage)gson.fromJson((Reader)bfr, ConfigStorage.class));
        }
        catch (IOException e) {
            logger.error("Load {} error: read file failed.", (Object)this.path, (Object)e);
            return false;
        }
        return true;
    }

    public ModConfig copy() {
        ModConfig newConfig = new ModConfig(this.path);
        ConfigStorage newStorage = new ConfigStorage();
        newStorage.checkUpdate = this.config.checkUpdate;
        newStorage.lang = this.config.lang;
        newStorage.autoRestartMode = this.config.autoRestartMode;
        newStorage.clientAutoReJoinWorld = this.config.clientAutoReJoinWorld;
        newStorage.storagePath = this.config.storagePath;
        newStorage.cacheDatabase = this.config.cacheDatabase;
        newStorage.ignoredFiles = new ArrayList<String>(this.config.ignoredFiles);
        newStorage.ignoredFolders = new ArrayList<String>(this.config.ignoredFolders);
        newStorage.scheduleBackup = new ScheduleBackupConfig();
        newStorage.scheduleBackup.enabled = this.config.scheduleBackup.enabled;
        newStorage.scheduleBackup.interval = this.config.scheduleBackup.interval;
        newStorage.scheduleBackup.crontab = this.config.scheduleBackup.crontab;
        newStorage.scheduleBackup.resetTimerOnBackup = this.config.scheduleBackup.resetTimerOnBackup;
        newStorage.scheduleBackup.requireOnlinePlayers = this.config.scheduleBackup.requireOnlinePlayers;
        newStorage.scheduleBackup.requireOnlinePlayersIgnoreCarpetFakePlayer = this.config.scheduleBackup.requireOnlinePlayersIgnoreCarpetFakePlayer;
        newStorage.scheduleBackup.requireOnlinePlayersBlacklist = this.config.scheduleBackup.requireOnlinePlayersBlacklist;
        newStorage.prune = new PruneScheduleConfig();
        newStorage.prune.enabled = this.config.prune.enabled;
        newStorage.prune.interval = this.config.prune.interval;
        newStorage.prune.crontab = this.config.prune.crontab;
        newStorage.prune.timezoneOverride = this.config.prune.timezoneOverride;
        newStorage.prune.regularBackup = new PbsConfig();
        newStorage.prune.regularBackup.enabled = this.config.prune.regularBackup.enabled;
        newStorage.prune.regularBackup.maxAmount = this.config.prune.regularBackup.maxAmount;
        newStorage.prune.regularBackup.maxLifeTime = this.config.prune.regularBackup.maxLifeTime;
        newStorage.prune.regularBackup.last = this.config.prune.regularBackup.last;
        newStorage.prune.regularBackup.hour = this.config.prune.regularBackup.hour;
        newStorage.prune.regularBackup.day = this.config.prune.regularBackup.day;
        newStorage.prune.regularBackup.week = this.config.prune.regularBackup.week;
        newStorage.prune.regularBackup.month = this.config.prune.regularBackup.month;
        newStorage.prune.regularBackup.year = this.config.prune.regularBackup.year;
        newStorage.database = new DatabaseConfig();
        newStorage.database.backup = new ScheduleConfig();
        newStorage.database.backup.enabled = this.config.database.backup.enabled;
        newStorage.database.backup.interval = this.config.database.backup.interval;
        newStorage.database.backup.crontab = this.config.database.backup.crontab;
        newConfig.setConfig(newStorage);
        return newConfig;
    }

    public boolean isCheckUpdate() {
        return this.config.checkUpdate;
    }

    public ArrayList<String> getIgnoredFiles() {
        ArrayList<String> ignoredFiles = new ArrayList<String>(this.config.ignoredFiles);
        ignoredFiles.add("session.lock");
        return ignoredFiles;
    }

    public ArrayList<String> getIgnoredFolders() {
        return this.config.ignoredFolders;
    }

    public String getLang() {
        return this.config.lang;
    }

    public void setLang(String lang) {
        this.config.lang = lang;
        this.save();
    }

    public AutoRestartMode getAutoRestartMode() {
        return this.config.autoRestartMode;
    }

    public void setAutoRestartMode(AutoRestartMode autoRestartMode) {
        this.config.autoRestartMode = autoRestartMode;
        this.save();
    }

    public boolean isClientAutoReJoinWorld() {
        return this.config.clientAutoReJoinWorld;
    }

    public void setClientAutoReJoinWorld(boolean clientAutoReJoinWorld) {
        this.config.clientAutoReJoinWorld = clientAutoReJoinWorld;
        this.save();
    }

    public boolean isCacheDatabase() {
        return this.config.cacheDatabase;
    }

    public ScheduleBackupConfig getScheduleBackupConfig() {
        return this.config.scheduleBackup;
    }

    public PruneScheduleConfig getPruneScheduleConfig() {
        return this.config.prune;
    }

    public DatabaseConfig getDatabaseConfig() {
        return this.config.database;
    }

    @NotNull
    public String getStoragePath() {
        return this.config.storagePath;
    }

    public void setStoragePath(String storagePath) {
        this.config.storagePath = storagePath;
    }

    public void setConfig(ConfigStorage config) {
        this.config = config;
    }

    public ConfigStorage getConfig() {
        return this.config;
    }

    public static class ConfigStorage {
        private boolean checkUpdate = true;
        private ArrayList<String> ignoredFiles = new ArrayList();
        private ArrayList<String> ignoredFolders = new ArrayList();
        private String lang = "zh_cn";
        private AutoRestartMode autoRestartMode = AutoRestartMode.DEFAULT;
        private boolean clientAutoReJoinWorld = true;
        private String storagePath = "./QuickBackupMulti";
        private boolean cacheDatabase = false;
        private ScheduleBackupConfig scheduleBackup = new ScheduleBackupConfig();
        private PruneScheduleConfig prune = new PruneScheduleConfig();
        private DatabaseConfig database = new DatabaseConfig();

        public String toString() {
            return "ConfigStorage{checkUpdate=" + this.checkUpdate + ", ignoredFiles=" + String.valueOf(this.ignoredFiles) + ", ignoredFolders=" + String.valueOf(this.ignoredFolders) + ", lang='" + this.lang + "', autoRestartMode=" + String.valueOf((Object)this.autoRestartMode) + ", clientAutoReJoinWorld=" + this.clientAutoReJoinWorld + ", storagePath='" + this.storagePath + "', cacheDatabase=" + this.cacheDatabase + ", scheduleBackup=" + String.valueOf(this.scheduleBackup) + ", prune=" + String.valueOf(this.prune) + ", database=" + String.valueOf(this.database) + "}";
        }

        public void setCheckUpdate(boolean checkUpdate) {
            this.checkUpdate = checkUpdate;
        }

        public void setIgnoredFiles(ArrayList<String> ignoredFiles) {
            this.ignoredFiles = ignoredFiles;
        }

        public void setIgnoredFolders(ArrayList<String> ignoredFolders) {
            this.ignoredFolders = ignoredFolders;
        }

        public void setLang(String lang) {
            this.lang = lang;
        }

        public void setAutoRestartMode(AutoRestartMode autoRestartMode) {
            this.autoRestartMode = autoRestartMode;
        }

        public void setClientAutoReJoinWorld(boolean clientAutoReJoinWorld) {
            this.clientAutoReJoinWorld = clientAutoReJoinWorld;
        }

        public void setStoragePath(String storagePath) {
            this.storagePath = storagePath;
        }

        public void setCacheDatabase(boolean cacheDatabase) {
            this.cacheDatabase = cacheDatabase;
        }

        public void setScheduleBackup(ScheduleBackupConfig scheduleBackup) {
            this.scheduleBackup = scheduleBackup;
        }

        public void setPrune(PruneScheduleConfig prune) {
            this.prune = prune;
        }

        public void setDatabase(DatabaseConfig database) {
            this.database = database;
        }

        public boolean isCheckUpdate() {
            return this.checkUpdate;
        }

        public ArrayList<String> getIgnoredFiles() {
            return this.ignoredFiles;
        }

        public ArrayList<String> getIgnoredFolders() {
            return this.ignoredFolders;
        }

        public String getLang() {
            return this.lang;
        }

        public AutoRestartMode getAutoRestartMode() {
            return this.autoRestartMode;
        }

        public boolean isClientAutoReJoinWorld() {
            return this.clientAutoReJoinWorld;
        }

        public String getStoragePath() {
            return this.storagePath;
        }

        public boolean isCacheDatabase() {
            return this.cacheDatabase;
        }

        public ScheduleBackupConfig getScheduleBackup() {
            return this.scheduleBackup;
        }

        public PruneScheduleConfig getPrune() {
            return this.prune;
        }

        public DatabaseConfig getDatabase() {
            return this.database;
        }
    }

    public static enum AutoRestartMode {
        DISABLE,
        DEFAULT,
        MCSM;

    }
}

