/*
 * Decompiled with CFR 0.152.
 */
package io.github.skydynamic.quickbakcupmulti.event;

import io.github.skydynamic.quickbakcupmulti.QuickbakcupmultiReforged;
import io.github.skydynamic.quickbakcupmulti.config.ModConfig;
import io.github.skydynamic.quickbakcupmulti.config.PruneScheduleConfig;
import io.github.skydynamic.quickbakcupmulti.config.ScheduleBackupConfig;
import io.github.skydynamic.quickbakcupmulti.config.ScheduleConfig;
import io.github.skydynamic.quickbakcupmulti.schedule.ScheduleManager;
import io.github.skydynamic.quickbakcupmulti.schedule.runnables.DefaultDatabaseBackupRunnable;
import io.github.skydynamic.quickbakcupmulti.schedule.runnables.DefaultPruneRunnable;
import io.github.skydynamic.quickbakcupmulti.schedule.runnables.DefaultScheduleBackupRunnable;
import io.github.skydynamic.quickbakcupmulti.utils.DurationUtils;

public class OnLoadedWorldHandler {
    public static void handler() {
        OnLoadedWorldHandler.registerSchedules();
        ScheduleManager.startAllSchedule();
    }

    private static void registerSchedules() {
        ModConfig config = QuickbakcupmultiReforged.getModConfig();
        ScheduleConfig databaseBackupConfig = config.getDatabaseConfig().getBackup();
        if (databaseBackupConfig.enabled) {
            DefaultDatabaseBackupRunnable databaseBackupRunnable = new DefaultDatabaseBackupRunnable();
            if (databaseBackupConfig.crontab != null) {
                ScheduleManager.registerSchedule("databaseSchedule", databaseBackupConfig.crontab, (Runnable)databaseBackupRunnable);
            } else if (databaseBackupConfig.interval != null) {
                int interval = (int)DurationUtils.parseDurationToSeconds(databaseBackupConfig.interval);
                ScheduleManager.registerSchedule("databaseSchedule", interval, (Runnable)databaseBackupRunnable);
            }
        }
        ScheduleBackupConfig scheduleBackupConfig = config.getScheduleBackupConfig();
        if (scheduleBackupConfig.enabled) {
            DefaultScheduleBackupRunnable scheduleBackupRunnable = new DefaultScheduleBackupRunnable();
            if (scheduleBackupConfig.crontab != null) {
                ScheduleManager.registerSchedule("scheduleBackup", scheduleBackupConfig.crontab, (Runnable)scheduleBackupRunnable);
            } else if (scheduleBackupConfig.interval != null) {
                int interval = (int)DurationUtils.parseDurationToSeconds(scheduleBackupConfig.interval);
                ScheduleManager.registerSchedule("scheduleBackup", interval, (Runnable)scheduleBackupRunnable);
            }
        }
        PruneScheduleConfig pruneScheduleConfig = config.getPruneScheduleConfig();
        if (pruneScheduleConfig.enabled) {
            int interval;
            if (pruneScheduleConfig.regularBackup.enabled) {
                DefaultPruneRunnable pruneRunnable = DefaultPruneRunnable.PRUNE_REGULAR_BACKUP_RUNNABLE;
                if (pruneScheduleConfig.crontab != null) {
                    ScheduleManager.registerSchedule("pruneSchedule", pruneScheduleConfig.crontab, (Runnable)pruneRunnable);
                } else if (pruneScheduleConfig.interval != null) {
                    interval = (int)DurationUtils.parseDurationToSeconds(pruneScheduleConfig.interval);
                    ScheduleManager.registerSchedule("pruneSchedule", interval, (Runnable)pruneRunnable);
                }
            }
            if (pruneScheduleConfig.getTemporaryBackup().enabled) {
                DefaultPruneRunnable pruneTemporaryBackupRunnable = DefaultPruneRunnable.PRUNE_TEMPORARY_BACKUP_RUNNABLE;
                if (pruneScheduleConfig.getTemporaryBackup().crontab != null) {
                    ScheduleManager.registerSchedule("pruneTemporaryBackupSchedule", pruneScheduleConfig.getTemporaryBackup().crontab, (Runnable)pruneTemporaryBackupRunnable);
                } else if (pruneScheduleConfig.getTemporaryBackup().interval != null) {
                    interval = (int)DurationUtils.parseDurationToSeconds(pruneScheduleConfig.getTemporaryBackup().interval);
                    ScheduleManager.registerSchedule("pruneTemporaryBackupSchedule", interval, (Runnable)pruneTemporaryBackupRunnable);
                }
            }
        }
    }
}

