/*
 * Decompiled with CFR 0.152.
 */
package io.github.skydynamic.quickbakcupmulti.neoforge.events;

import com.mojang.brigadier.CommandDispatcher;
import io.github.skydynamic.quickbakcupmulti.QuickbakcupmultiReforged;
import io.github.skydynamic.quickbakcupmulti.config.ModConfig;
import io.github.skydynamic.quickbakcupmulti.event.OnServerStoppedHandler;
import io.github.skydynamic.quickbakcupmulti.neoforge.QuickbackupmultiReforgedNeoForge;
import io.github.skydynamic.quickbakcupmulti.neoforge.ServerManagerNeoforge;
import io.github.skydynamic.quickbakcupmulti.utils.BackupManager;
import net.minecraft.commands.CommandSourceStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;

@EventBusSubscriber(modid="quickbakcupmulti_reforged")
public class NeoForgeEvents {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        QuickbackupmultiReforgedNeoForge.getModContainer().setDispatcher((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        QuickbakcupmultiReforged.registerCommand();
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        QuickbakcupmultiReforged.setServerManager(new ServerManagerNeoforge(event.getServer()));
        if (QuickbakcupmultiReforged.getModContainer().isRestoringBackup()) {
            QuickbakcupmultiReforged.getModContainer().setRestoringBackup(false);
        }
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    @SubscribeEvent
    public static void onDedicatedServerStopped(ServerStoppedEvent event) {
        if (QuickbakcupmultiReforged.getModContainer().isRestoringBackup()) {
            if (QuickbakcupmultiReforged.getModConfig().getAutoRestartMode() == ModConfig.AutoRestartMode.DEFAULT) {
                BackupManager.restoreBackup(QuickbakcupmultiReforged.getModContainer().getCurrentSelectionBackup());
                QuickbakcupmultiReforged.getServerManager().startServer();
            } else {
                OnServerStoppedHandler.handle();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onIntegratedServerStopped(ServerStoppedEvent event) {
        OnServerStoppedHandler.handle();
    }
}

