/*
 * Decompiled with CFR 0.152.
 */
package io.github.skydynamic.quickbakcupmulti.neoforge.restart;

import io.github.skydynamic.quickbakcupmulti.QuickbakcupmultiReforged;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;

public class NeoforgeRestart {
    private static final RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();

    public static List<String> generateUnixRestartCommand() {
        String jre = System.getProperty("java.home") + "/bin/java";
        return NeoforgeRestart.generateRestartCommand(jre);
    }

    public static List<String> generateWindowsRestartCommand() {
        String jre = System.getProperty("java.home") + "\\bin\\java.exe";
        return NeoforgeRestart.generateRestartCommand(jre);
    }

    private static List<String> generateRestartCommand(String jre) {
        String cp = runtimeMxBean.getClassPath();
        String mainClass = runtimeMxBean.getSystemProperties().get("sun.java.command");
        ArrayList<String> arguments = new ArrayList<String>(runtimeMxBean.getInputArguments());
        if (mainClass == null || mainClass.isEmpty()) {
            throw new IllegalArgumentException("Main class is not specified.");
        }
        if (cp.isEmpty()) {
            throw new IllegalArgumentException("Classpath is empty.");
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(jre);
        command.add("-cp");
        command.add(cp);
        command.add("-XstartOnFirstThread");
        command.addAll(arguments);
        command.addAll(List.of(mainClass.split(" ")));
        return command;
    }

    public static void restartServer() {
        List<String> command;
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            command = NeoforgeRestart.generateWindowsRestartCommand();
            command.remove("-XstartOnFirstThread");
        } else {
            command = NeoforgeRestart.generateUnixRestartCommand();
        }
        try {
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.inheritIO();
            builder.start();
            System.exit(0);
        }
        catch (Exception e) {
            QuickbakcupmultiReforged.logger.error("Failed to restart server", (Throwable)e);
        }
    }
}

