/*
 * Decompiled with CFR 0.152.
 */
package io.github.skydynamic.quickbakcupmulti.restore;

import io.github.skydynamic.quickbakcupmulti.QuickbakcupmultiReforged;
import io.github.skydynamic.quickbakcupmulti.client.screen.RestoreScreen;
import io.github.skydynamic.quickbakcupmulti.translate.Translate;
import io.github.skydynamic.quickbakcupmulti.utils.BackupManager;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.LevelStorageSource;

public class ClientRestoreDelegate {
    private final RestoreScreen screen = new RestoreScreen(this::cancel);
    private CompletableFuture<Void> restoreFuture = null;
    private final AtomicBoolean isCancelled = new AtomicBoolean(false);
    protected final Minecraft minecraftClient = Minecraft.getInstance();
    String levelId = QuickbakcupmultiReforged.getModContainer().getLevelId();

    public void run() {
        long startTime = System.currentTimeMillis();
        this.minecraftClient.executeBlocking(() -> {
            if (this.minecraftClient.level != null) {
                this.minecraftClient.level.disconnect((Component)Component.translatable((String)"multiplayer.status.quitting"));
            }
            this.minecraftClient.disconnect((Screen)this.screen, false);
        });
        this.restoreFuture = CompletableFuture.runAsync(() -> {
            this.screen.setState(Translate.tr("quickbackupmulti.restoring_backup.state.make_temp_backup", new Object[0]));
            this.screen.setProgress(0.05f);
            BackupManager.makeTempBackup();
            this.screen.setState(Translate.tr("quickbackupmulti.restoring_backup.state.delete_origin_save", new Object[0]));
            this.screen.setProgress(0.1f);
            this.deleteWorld();
            if (this.isCancelled.get()) {
                this.handleCancellation();
                return;
            }
            BackupManager.RestoreExtraRunnable extraRunnable = (totalProgress, currentProgress) -> {
                this.screen.setState(Translate.tr("quickbackupmulti.restoring_backup.state.restoring_backup", new Object[0]));
                this.screen.setProgress((float)currentProgress / (float)totalProgress * 0.9f);
            };
            BackupManager.restoreBackup(QuickbakcupmultiReforged.getModContainer().getCurrentSelectionBackup(), extraRunnable);
            if (this.isCancelled.get()) {
                this.handleCancellation();
                return;
            }
            QuickbakcupmultiReforged.getModContainer().setRestoringBackup(false);
            long endTime = System.currentTimeMillis();
            this.minecraftClient.execute(() -> {
                Component title = Component.nullToEmpty((String)Translate.tr("quickbackupmulti.toast.end_title", new Object[0]));
                Component desc = Component.nullToEmpty((String)Translate.tr("quickbackupmulti.toast.end_desc", (int)(endTime - startTime * 1000L)));
                SystemToast.addOrUpdate((ToastManager)this.minecraftClient.getToastManager(), (SystemToast.SystemToastId)SystemToast.SystemToastId.PERIODIC_NOTIFICATION, (Component)title, (Component)desc);
            });
            if (QuickbakcupmultiReforged.getModConfig().isClientAutoReJoinWorld()) {
                this.minecraftClient.execute(() -> this.minecraftClient.createWorldOpenFlows().openWorld(this.levelId, () -> this.minecraftClient.setScreen(null)));
            } else {
                this.minecraftClient.execute(() -> this.minecraftClient.setScreen(null));
            }
        }, Executors.newSingleThreadExecutor());
    }

    private void handleCancellation() {
        try {
            this.screen.setState(Translate.tr("quickbackupmulti.restoring_backup.state.delete_origin_save", new Object[0]));
            this.deleteWorld();
            this.screen.setState(Translate.tr("quickbackupmulti.restoring_backup.state.restore_temp_backup", new Object[0]));
            BackupManager.restoreBackup("restore_temp");
            this.minecraftClient.execute(() -> {
                Component title = Component.nullToEmpty((String)Translate.tr("quickbackupmulti.toast.cancel_success", new Object[0]));
                Component desc = Component.nullToEmpty((String)Translate.tr("quickbackupmulti.toast.cancel_success.desc", new Object[0]));
                SystemToast.addOrUpdate((ToastManager)this.minecraftClient.getToastManager(), (SystemToast.SystemToastId)SystemToast.SystemToastId.PERIODIC_NOTIFICATION, (Component)title, (Component)desc);
                this.minecraftClient.setScreen(null);
            });
        }
        catch (Exception e) {
            QuickbakcupmultiReforged.logger.error("Error during cancellation", (Throwable)e);
        }
    }

    public void cancel(Button button) {
        this.isCancelled.set(true);
        if (button != null) {
            this.screen.setState(Translate.tr("quickbackupmulti.restoring_backup.state.cancel", new Object[0]));
            button.active = false;
        }
        QuickbakcupmultiReforged.getModContainer().setRestoringBackup(false);
    }

    private void deleteWorld() {
        try (LevelStorageSource.LevelStorageAccess levelStorageSource = this.minecraftClient.getLevelSource().createAccess(this.levelId);){
            levelStorageSource.deleteLevel();
        }
        catch (IOException e) {
            QuickbakcupmultiReforged.logger.error("Error during delete level", (Throwable)e);
        }
    }
}

