/*
 * Decompiled with CFR 0.152.
 */
package io.github.skydynamic.quickbakcupmulti.schedule;

import io.github.skydynamic.quickbakcupmulti.QuickbakcupmultiReforged;
import java.text.ParseException;
import java.util.Date;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class CronUtils {
    public static <T> Trigger buildTrigger(String name, ScheduleMode mode, T value) {
        IllegalArgumentException buildException = new IllegalArgumentException("Schedule mode %s requires value of type %s, but got %s (value: %s)".formatted(mode.name(), mode.type.getName(), value.getClass().getName(), value));
        switch (mode.ordinal()) {
            case 0: {
                if (value instanceof Integer) {
                    Integer v = (Integer)value;
                    return TriggerBuilder.newTrigger().withIdentity(name).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(v.intValue()).repeatForever()).startAt(new Date(System.currentTimeMillis() + (long)v.intValue() * 1000L)).build();
                }
                QuickbakcupmultiReforged.logger.error("Failed to build schedule trigger", (Throwable)buildException);
                break;
            }
            case 1: {
                if (value instanceof String) {
                    String v = (String)value;
                    if (!CronUtils.cronIsValid(v)) {
                        QuickbakcupmultiReforged.logger.error("Failed to build schedule trigger, CronExpression {} is invalid", (Object)v);
                        return null;
                    }
                    return TriggerBuilder.newTrigger().withIdentity(name).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)v)).startAt(new Date(CronUtils.getNextExecutionTime(v).getTime())).build();
                }
                QuickbakcupmultiReforged.logger.error("Failed to build schedule trigger", (Throwable)buildException);
            }
        }
        return null;
    }

    public static Date getNextExecutionTime(String cronExpress) {
        try {
            CronExpression cronExpression = new CronExpression(cronExpress);
            return cronExpression.getNextValidTimeAfter(new Date());
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    public static boolean cronIsValid(String cronExpression) {
        try {
            new CronExpression(cronExpression);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static enum ScheduleMode {
        INTERVAL(Integer.class),
        CRONTAB(String.class);

        private final Class<?> type;

        private ScheduleMode(Class<?> type) {
            this.type = type;
        }
    }
}

