/*
 * Decompiled with CFR 0.152.
 */
package io.github.skydynamic.quickbakcupmulti.schedule.impl;

import io.github.skydynamic.quickbakcupmulti.QuickbakcupmultiReforged;
import io.github.skydynamic.quickbakcupmulti.schedule.CronUtils;
import io.github.skydynamic.quickbakcupmulti.schedule.IModSchedule;
import io.github.skydynamic.quickbakcupmulti.schedule.ModJob;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class ModSchedule
implements IModSchedule {
    private String identity;
    private String crontab;
    private Integer interval;
    private Runnable executor;
    protected JobDetail jobDetail;
    protected Trigger trigger;
    protected Scheduler scheduler;

    public ModSchedule() {
    }

    public ModSchedule(String identity, Integer interval) {
        this.identity = identity;
        this.interval = interval;
    }

    public ModSchedule(String identity, String crontab) {
        this.identity = identity;
        this.crontab = crontab;
    }

    @Override
    public String getName() {
        return this.identity;
    }

    @Override
    public boolean startSchedule() {
        this.jobDetail = JobBuilder.newJob(ModJob.class).withIdentity(this.identity).build();
        StdSchedulerFactory sf = new StdSchedulerFactory();
        if (this.crontab != null && !this.crontab.isEmpty()) {
            this.trigger = CronUtils.buildTrigger(this.identity, CronUtils.ScheduleMode.CRONTAB, this.crontab);
        } else if (this.interval != null && this.interval > 0) {
            this.trigger = CronUtils.buildTrigger(this.identity, CronUtils.ScheduleMode.INTERVAL, this.interval);
        } else {
            return false;
        }
        if (this.trigger == null) {
            return false;
        }
        try {
            this.scheduler = sf.getScheduler();
            this.scheduler.scheduleJob(this.jobDetail, this.trigger);
            this.scheduler.start();
            return true;
        }
        catch (SchedulerException e) {
            QuickbakcupmultiReforged.logger.error("Failed to get scheduler", (Throwable)e);
            return false;
        }
    }

    @Override
    public void stopSchedule() {
        try {
            this.scheduler.shutdown(true);
        }
        catch (SchedulerException e) {
            QuickbakcupmultiReforged.logger.error("Failed to stop scheduler", (Throwable)e);
        }
    }

    @Override
    public ModSchedule setExecutor(Runnable executor) {
        this.executor = executor;
        return this;
    }

    @Override
    public boolean isRunning() {
        try {
            return this.scheduler.isStarted();
        }
        catch (SchedulerException e) {
            return false;
        }
    }

    @Override
    public long getNextExecuteTime() {
        return this.trigger.getNextFireTime().getTime();
    }

    @Override
    public boolean resetTimer() {
        if (this.scheduler != null) {
            this.stopSchedule();
            return this.startSchedule();
        }
        return false;
    }

    @Override
    public void execute() {
        QuickbakcupmultiReforged.logger.info("Schedule {} execute in {}", (Object)this.identity, (Object)QuickbakcupmultiReforged.formatTimestamp(System.currentTimeMillis()));
        this.executor.run();
        QuickbakcupmultiReforged.logger.info("Schedule {} execute done, next execute time: {}", (Object)this.identity, (Object)QuickbakcupmultiReforged.formatTimestamp(this.trigger.getNextFireTime().getTime()));
    }
}

